/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IArchimateDiagramEditor;
import com.archimatetool.editor.ui.components.PartListenerAdapter;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.Objects;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class TreeViewpointFilterProvider {
    private IArchimateDiagramModel activeDiagramModel;
    private TreeModelViewer treeViewer;
    private Color colorGrey = new Color(128, 128, 128);
    private IPartListener partListener = new PartListenerAdapter(){

        @Override
        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                IArchimateDiagramModel previousDiagramModel = TreeViewpointFilterProvider.this.activeDiagramModel;
                if (part instanceof IArchimateDiagramEditor) {
                    IArchimateDiagramEditor diagramEditor = (IArchimateDiagramEditor)part;
                    v0 = (IArchimateDiagramModel)diagramEditor.getModel();
                } else {
                    v0 = TreeViewpointFilterProvider.this.activeDiagramModel = null;
                }
                if (TreeViewpointFilterProvider.this.isActive()) {
                    if (TreeViewpointFilterProvider.this.activeDiagramModel != null && previousDiagramModel != null && TreeViewpointFilterProvider.this.activeDiagramModel.getArchimateModel() == previousDiagramModel.getArchimateModel()) {
                        if (!Objects.equals(previousDiagramModel.getViewpoint(), TreeViewpointFilterProvider.this.activeDiagramModel.getViewpoint())) {
                            TreeViewpointFilterProvider.this.treeViewer.updateInBackground(TreeViewpointFilterProvider.this.activeDiagramModel.getArchimateModel());
                        }
                    } else {
                        if (previousDiagramModel != null) {
                            TreeViewpointFilterProvider.this.treeViewer.updateInBackground(previousDiagramModel.getArchimateModel());
                        }
                        if (TreeViewpointFilterProvider.this.activeDiagramModel != null) {
                            TreeViewpointFilterProvider.this.treeViewer.updateInBackground(TreeViewpointFilterProvider.this.activeDiagramModel.getArchimateModel());
                        }
                    }
                }
            }
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart && part.getSite().getPage().getActiveEditor() == null) {
                TreeViewpointFilterProvider.this.activeDiagramModel = null;
                if (TreeViewpointFilterProvider.this.isActive()) {
                    TreeViewpointFilterProvider.this.treeViewer.updateInBackground();
                }
            }
        }
    };

    TreeViewpointFilterProvider(IWorkbenchWindow window, TreeModelViewer viewer) {
        this.treeViewer = viewer;
        window.getPartService().addPartListener(this.partListener);
        this.treeViewer.getControl().addDisposeListener(event -> {
            window.getPartService().removePartListener(this.partListener);
            this.activeDiagramModel = null;
            this.treeViewer = null;
        });
    }

    Color getTextColor(Object object) {
        IViewpoint viewpoint;
        IArchimateConcept concept;
        if (this.isActive() && this.activeDiagramModel != null && object instanceof IArchimateConcept && (concept = (IArchimateConcept)object).getArchimateModel() == this.activeDiagramModel.getArchimateModel() && (viewpoint = ViewpointManager.INSTANCE.getViewpoint(this.activeDiagramModel.getViewpoint())) != null) {
            if (concept instanceof IArchimateRelationship) {
                IArchimateRelationship relation = (IArchimateRelationship)concept;
                IArchimateConcept source = relation.getSource();
                IArchimateConcept target = relation.getTarget();
                return viewpoint.isAllowedConcept(source.eClass()) && viewpoint.isAllowedConcept(target.eClass()) ? null : this.colorGrey;
            }
            if (object instanceof IArchimateElement) {
                IArchimateElement element = (IArchimateElement)object;
                return viewpoint.isAllowedConcept(element.eClass()) ? null : this.colorGrey;
            }
        }
        return null;
    }

    boolean isActive() {
        return ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsFilterModelTree");
    }
}

