/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.views.tree.TreeModelCutAndPaste;
import com.archimatetool.editor.views.tree.actions.Messages;
import com.archimatetool.editor.views.tree.actions.ViewerAction;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class CutAction
extends ViewerAction {
    public CutAction(ISelectionProvider selectionProvider) {
        super(selectionProvider);
        this.setText(Messages.CutAction_0);
        this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setEnabled(false);
    }

    public void run() {
        List<IArchimateModelObject> validObjects = this.getValidSelection();
        if (validObjects.isEmpty()) {
            this.setEnabled(false);
        } else {
            TreeModelCutAndPaste.INSTANCE.setContents(validObjects);
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.getValidSelection().isEmpty());
    }

    private List<IArchimateModelObject> getValidSelection() {
        ArrayList<IArchimateModelObject> validObjects = new ArrayList<IArchimateModelObject>();
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            for (Object object : selection.toList()) {
                if (!this.isAllowedToCut(object)) continue;
                validObjects.add((IArchimateModelObject)object);
            }
        }
        return validObjects;
    }

    private boolean isAllowedToCut(Object object) {
        return object instanceof IArchimateConcept || object instanceof IDiagramModel || object instanceof IFolder && ((IFolder)object).getType() == FolderType.USER;
    }
}

