/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.editor.views.tree.actions.Messages;
import com.archimatetool.editor.views.tree.actions.ViewerAction;
import com.archimatetool.editor.views.tree.commands.DeleteCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends ViewerAction {
    public DeleteAction(TreeModelViewer selectionProvider) {
        super((ISelectionProvider)selectionProvider);
        this.setText(Messages.DeleteAction_0);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setEnabled(false);
    }

    public void run() {
        IStructuredSelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        final DeleteCommandHandler cmdHandler = new DeleteCommandHandler((TreeModelViewer)this.getSelectionProvider(), selection.toArray());
        if (cmdHandler.hasDiagramReferences() ? !MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeleteAction_1, (String)(Messages.DeleteAction_2 + "\n" + Messages.DeleteAction_3)) : ArchiPlugin.getInstance().getPreferenceStore().getBoolean("showWarningOnDeleteFromTree") && !MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeleteAction_1, (String)Messages.DeleteAction_3)) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                cmdHandler.delete();
            }
        });
    }

    @Override
    public void update() {
        this.setEnabled(false);
        for (Object element : this.getSelection().toList()) {
            if (!DeleteCommandHandler.canDelete(element)) continue;
            this.setEnabled(true);
            break;
        }
    }
}

