/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.actions.ArchiActionFactory;
import com.archimatetool.editor.tools.GenerateViewCommand;
import com.archimatetool.editor.views.tree.actions.Messages;
import com.archimatetool.editor.views.tree.actions.ViewerAction;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

public class GenerateViewAction
extends ViewerAction {
    public GenerateViewAction(ISelectionProvider selectionProvider) {
        super(selectionProvider);
        this.setText(Messages.GenerateViewAction_0);
        this.setActionDefinitionId(ArchiActionFactory.GENERATE_VIEW.getCommandId());
    }

    public void run() {
        GenerateViewCommand command;
        List<IArchimateElement> selected = this.getValidSelectedObjects(this.getSelection());
        if (!selected.isEmpty() && (command = new GenerateViewCommand(selected)).openDialog(Display.getCurrent().getActiveShell())) {
            CommandStack commandStack = (CommandStack)selected.get(0).getAdapter(CommandStack.class);
            commandStack.execute((Command)command);
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.getValidSelectedObjects(this.getSelection()).isEmpty());
    }

    private List<IArchimateElement> getValidSelectedObjects(IStructuredSelection selection) {
        ArrayList<IArchimateElement> list = new ArrayList<IArchimateElement>();
        if (this.isSameModel(selection)) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof IArchimateElement && !list.contains(o)) {
                    list.add((IArchimateElement)o);
                }
                ++n2;
            }
        }
        return list;
    }

    private boolean isSameModel(IStructuredSelection selection) {
        IArchimateModel model = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IArchimateModelObject) {
                IArchimateModel nextModel = ((IArchimateModelObject)o).getArchimateModel();
                if (model != null && model != nextModel) {
                    return false;
                }
                model = nextModel;
            }
            ++n2;
        }
        return true;
    }
}

