/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.editor.views.tree.actions.Messages;
import com.archimatetool.editor.views.tree.actions.ViewerAction;
import com.archimatetool.model.IArchimateModel;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveModelAction
extends ViewerAction {
    private ITreeModelView fView;

    public SaveModelAction(ITreeModelView view) {
        super(view.getSelectionProvider());
        this.setText(Messages.SaveModelAction_0);
        this.fView = view;
        this.setActionDefinitionId("org.eclipse.ui.file.save");
    }

    public void run() {
        IArchimateModel model = this.getModel();
        if (model != null) {
            try {
                IEditorModelManager.INSTANCE.saveModel(model);
            }
            catch (IOException ex) {
                MessageDialog.openError((Shell)this.fView.getSite().getShell(), (String)Messages.SaveModelAction_1, (String)ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void update() {
        this.setEnabled(IEditorModelManager.INSTANCE.isModelDirty(this.getModel()));
    }

    private IArchimateModel getModel() {
        return (IArchimateModel)this.fView.getAdapter(IArchimateModel.class);
    }
}

