/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.views.tree.commands.Messages;
import com.archimatetool.model.IFolder;
import org.eclipse.gef.commands.Command;

public class MoveFolderCommand
extends Command {
    private IFolder fOldParent;
    private IFolder fNewParent;
    private IFolder fFolder;
    private int fOldPos;

    public MoveFolderCommand(IFolder newParent, IFolder folder) {
        super(Messages.MoveFolderCommand_0);
        this.fOldParent = (IFolder)folder.eContainer();
        this.fNewParent = newParent;
        this.fFolder = folder;
    }

    public void execute() {
        this.fOldPos = this.fOldParent.getFolders().indexOf((Object)this.fFolder);
        this.redo();
    }

    public void undo() {
        this.fNewParent.getFolders().remove((Object)this.fFolder);
        this.fOldParent.getFolders().add(this.fOldPos, (Object)this.fFolder);
    }

    public void redo() {
        this.fOldParent.getFolders().remove((Object)this.fFolder);
        this.fNewParent.getFolders().add((Object)this.fFolder);
    }

    public void dispose() {
        this.fOldParent = null;
        this.fNewParent = null;
        this.fFolder = null;
    }
}

