/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.views.tree.commands.Messages;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IFolder;
import org.eclipse.gef.commands.Command;

public class MoveObjectCommand
extends Command {
    private IFolder fOldParent;
    private IFolder fNewParent;
    private IArchimateModelObject fObject;
    private int fOldPos;

    public MoveObjectCommand(IFolder newParent, IArchimateModelObject object) {
        super(Messages.MoveObjectCommand_0);
        this.fOldParent = (IFolder)object.eContainer();
        this.fNewParent = newParent;
        this.fObject = object;
    }

    public void execute() {
        this.fOldPos = this.fOldParent.getElements().indexOf((Object)this.fObject);
        this.redo();
    }

    public void undo() {
        this.fNewParent.getElements().remove((Object)this.fObject);
        this.fOldParent.getElements().add(this.fOldPos, (Object)this.fObject);
    }

    public void redo() {
        this.fOldParent.getElements().remove((Object)this.fObject);
        this.fNewParent.getElements().add((Object)this.fObject);
    }

    public void dispose() {
        this.fOldParent = null;
        this.fNewParent = null;
        this.fObject = null;
    }
}

