/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.services.UIRequestManager;
import com.archimatetool.editor.views.tree.TreeEditElementRequest;
import com.archimatetool.editor.views.tree.TreeSelectionRequest;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class NewDiagramCommand
extends Command {
    private IFolder fFolder;
    private IDiagramModel fDiagramModel;

    public NewDiagramCommand(IFolder folder, IDiagramModel diagramModel, String label) {
        super(label);
        this.fFolder = folder;
        this.fDiagramModel = diagramModel;
    }

    public void execute() {
        this.redo();
        UIRequestManager.INSTANCE.fireRequest(new TreeEditElementRequest((Object)this, this.fDiagramModel));
    }

    public void undo() {
        EditorManager.closeDiagramEditor(this.fDiagramModel);
        this.fFolder.getElements().remove((Object)this.fDiagramModel);
        TreeSelectionRequest request = new TreeSelectionRequest((Object)this, (IStructuredSelection)new StructuredSelection((Object)this.fFolder), true){

            @Override
            public boolean shouldSelect(Viewer viewer) {
                return viewer.getSelection().isEmpty();
            }
        };
        UIRequestManager.INSTANCE.fireRequest(request);
    }

    public void redo() {
        this.fFolder.getElements().add((Object)this.fDiagramModel);
        UIRequestManager.INSTANCE.fireRequest(new TreeSelectionRequest((Object)this, (IStructuredSelection)new StructuredSelection((Object)this.fDiagramModel), true));
        EditorManager.openDiagramEditor(this.fDiagramModel, false);
    }

    public void dispose() {
        this.fFolder = null;
        this.fDiagramModel = null;
    }
}

