/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.views.tree.commands.Messages;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAdapter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.INameable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;

public class RenameCommandHandler {
    public static boolean canRename(Object element) {
        if (element instanceof IFolder) {
            return ((IFolder)element).getType() == FolderType.USER;
        }
        return element instanceof INameable && element instanceof IAdapter;
    }

    public static void doRenameCommand(INameable element, String newText) {
        CommandStack stack = (CommandStack)((IAdapter)element).getAdapter(CommandStack.class);
        if (stack != null) {
            stack.execute((Command)new EObjectFeatureCommand(Messages.RenameCommandHandler_0, (EObject)element, (EStructuralFeature)IArchimatePackage.Literals.NAMEABLE__NAME, newText));
        }
    }

    public static void doRenameCommands(List<INameable> elements, List<String> newNames) {
        if (elements.size() != newNames.size() || elements.isEmpty()) {
            return;
        }
        Hashtable<CommandStack, CompoundCommand> commandMap = new Hashtable<CommandStack, CompoundCommand>();
        int i = 0;
        while (i < elements.size()) {
            INameable element = elements.get(i);
            String newName = newNames.get(i);
            CompoundCommand compoundCommand = RenameCommandHandler.getCompoundCommand((IAdapter)element, commandMap);
            if (compoundCommand != null) {
                EObjectFeatureCommand cmd = new EObjectFeatureCommand(Messages.RenameCommandHandler_0, (EObject)element, (EStructuralFeature)IArchimatePackage.Literals.NAMEABLE__NAME, newName);
                compoundCommand.add((Command)cmd);
            } else {
                System.err.println("Could not get CompoundCommand in doRenameCommands");
            }
            ++i;
        }
        for (Map.Entry entry : commandMap.entrySet()) {
            ((CommandStack)entry.getKey()).execute(((CompoundCommand)entry.getValue()).unwrap());
        }
    }

    private static CompoundCommand getCompoundCommand(IAdapter object, Hashtable<CommandStack, CompoundCommand> commandMap) {
        CommandStack stack = (CommandStack)object.getAdapter(CommandStack.class);
        if (stack == null) {
            System.err.println("CommandStack was null in getCompoundCommand");
            return null;
        }
        CompoundCommand compoundCommand = commandMap.get(stack);
        if (compoundCommand == null) {
            compoundCommand = new NonNotifyingCompoundCommand(Messages.RenameCommandHandler_0);
            commandMap.put(stack, compoundCommand);
        }
        return compoundCommand;
    }
}

