/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.views.tree.commands.Messages;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IFolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class SortFolderCommand
extends Command
implements Comparator<EObject> {
    private IFolder fFolder;
    private List<EObject> fList;

    public SortFolderCommand(IFolder folder) {
        this.setLabel(Messages.SortFolderCommand_0);
        this.fFolder = folder;
        this.fList = new ArrayList<EObject>();
        for (EObject o : this.fFolder.getElements()) {
            this.fList.add(o);
        }
    }

    public void execute() {
        IEditorModelManager.INSTANCE.firePropertyChange(this, "IEditorModelManager.ecore.events.start", false, true);
        ECollections.sort((EList)this.fFolder.getElements(), (Comparator)this);
        IEditorModelManager.INSTANCE.firePropertyChange(this, "IEditorModelManager.ecore.events.end", false, true);
    }

    public void undo() {
        IEditorModelManager.INSTANCE.firePropertyChange(this, "IEditorModelManager.ecore.events.start", false, true);
        this.fFolder.getElements().clear();
        this.fFolder.getElements().addAll(this.fList);
        IEditorModelManager.INSTANCE.firePropertyChange(this, "IEditorModelManager.ecore.events.end", false, true);
    }

    public void dispose() {
        this.fFolder = null;
        this.fList = null;
    }

    @Override
    public int compare(EObject o1, EObject o2) {
        String name1 = null;
        String name2 = null;
        if (o1 instanceof IDiagramModelComponent && o2 instanceof IDiagramModelComponent) {
            name1 = ((IDiagramModelComponent)o1).getName();
            name2 = ((IDiagramModelComponent)o2).getName();
        } else if (o1 instanceof IArchimateConcept && o2 instanceof IArchimateConcept) {
            name1 = ((IArchimateConcept)o1).getName();
            name2 = ((IArchimateConcept)o2).getName();
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        return name1.compareTo(name2);
    }
}

