/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.search;

import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDocumentable;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IFolderContainer;
import com.archimatetool.model.INameable;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SearchFilter
extends ViewerFilter {
    private String fSearchText = "";
    private boolean filterName;
    private boolean filterDocumentation;
    private boolean filterPropertyValues;
    private boolean filterViews;
    private boolean showAllFolders;
    private boolean matchCase;
    private boolean useRegex;
    private Set<String> propertyKeyFilter = new HashSet<String>();
    private Set<EClass> conceptsFilter = new HashSet<EClass>();
    private Set<IProfile> specializationsFilter = new HashSet<IProfile>();
    private Matcher regexMatcher;

    SearchFilter() {
    }

    void setSearchText(String text) {
        this.fSearchText = text;
        this.createRegexMatcher();
    }

    void reset() {
        this.setFilterOnName(true);
        this.setFilterOnDocumentation(false);
        this.setFilterOnPropertyValues(false);
        this.resetConceptsFilter();
        this.resetPropertyKeyFilter();
        this.resetSpecializationsFilter();
        this.setFilterViews(false);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.isFiltering()) {
            return true;
        }
        return this.isElementVisible(element);
    }

    private boolean isElementVisible(Object element) {
        if (element instanceof IFolderContainer) {
            IFolderContainer container = (IFolderContainer)element;
            for (IFolder folder : container.getFolders()) {
                if (!this.isElementVisible(folder)) continue;
                return true;
            }
        }
        if (element instanceof IFolder) {
            IFolder folder;
            folder = (IFolder)element;
            for (Object o : folder.getElements()) {
                if (!this.isElementVisible(o)) continue;
                return true;
            }
            if (this.getShowAllFolders()) {
                return true;
            }
        }
        return this.matchesFilter(element);
    }

    public boolean matchesFilter(Object element) {
        boolean show = true;
        if (this.isFilteringConcepts() || this.isFilteringSpecializations() || this.isFilteringViews()) {
            boolean bl = show = this.isFilteringConcepts() && this.shouldShowConcept(element) || this.isFilteringSpecializations() && this.shouldShowSpecialization(element) || this.isFilteringViews() && element instanceof IDiagramModel;
        }
        if (this.isFilteringName() || this.isFilteringDocumentation() || this.isFilteringPropertyKeys() || this.isFilteringPropertyValues()) {
            show &= this.isFilteringName() && this.shouldShowObjectWithName(element) || this.isFilteringDocumentation() && this.shouldShowObjectWithDocumentation(element) || (this.isFilteringPropertyKeys() || this.isFilteringPropertyValues()) && this.shouldShowObjectWithProperty(element);
        }
        return show;
    }

    private boolean shouldShowConcept(Object element) {
        return this.conceptsFilter.contains(((EObject)element).eClass());
    }

    private boolean shouldShowSpecialization(Object element) {
        if (element instanceof IArchimateConcept) {
            IArchimateConcept concept = (IArchimateConcept)element;
            for (IProfile profile : concept.getProfiles()) {
                for (IProfile p : this.specializationsFilter) {
                    if (!ArchimateModelUtils.isMatchingProfile((IProfile)p, (IProfile)profile)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldShowObjectWithName(Object element) {
        if (element instanceof INameable) {
            INameable nameable = (INameable)element;
            String name = StringUtils.safeString(nameable.getName());
            return this.matchesString(name);
        }
        return false;
    }

    private boolean shouldShowObjectWithDocumentation(Object element) {
        if (element instanceof IDocumentable) {
            IDocumentable documentable = (IDocumentable)element;
            String text = StringUtils.safeString(documentable.getDocumentation());
            return this.matchesString(text);
        }
        if (element instanceof IArchimateModel) {
            IArchimateModel model = (IArchimateModel)element;
            String text = StringUtils.safeString(model.getPurpose());
            return this.matchesString(text);
        }
        return false;
    }

    private boolean shouldShowObjectWithProperty(Object element) {
        if (element instanceof IProperties) {
            IProperties properties = (IProperties)element;
            for (IProperty property : properties.getProperties()) {
                if (this.isFilteringPropertyKeys()) {
                    if (!this.propertyKeyFilter.contains(property.getKey())) continue;
                    return this.isFilteringPropertyValues() ? this.matchesString(property.getValue()) : true;
                }
                if (!this.matchesString(property.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesString(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        if (this.getUseRegex()) {
            return this.matchesRegexString(str);
        }
        if (this.getMatchCase()) {
            return str.contains(this.fSearchText);
        }
        return str.toLowerCase().contains(this.fSearchText.toLowerCase());
    }

    private boolean matchesRegexString(String searchString) {
        return this.regexMatcher != null ? this.regexMatcher.reset(searchString).find() : false;
    }

    private void createRegexMatcher() {
        this.regexMatcher = null;
        if (this.getUseRegex() && this.hasSearchText()) {
            try {
                Pattern pattern = Pattern.compile(this.fSearchText, this.getMatchCase() ? 0 : 2);
                this.regexMatcher = pattern.matcher("");
            }
            catch (Exception exception) {}
        }
    }

    public boolean isFiltering() {
        return this.isFilteringName() || this.isFilteringDocumentation() || this.isFilteringConcepts() || this.isFilteringPropertyKeys() || this.isFilteringPropertyValues() || this.isFilteringSpecializations() || this.isFilteringViews();
    }

    private boolean hasSearchText() {
        return this.fSearchText.length() > 0;
    }

    boolean isValidSearchString() {
        if (this.getUseRegex() && this.hasSearchText()) {
            return this.regexMatcher != null;
        }
        return true;
    }

    void setFilterOnName(boolean set) {
        this.filterName = set;
    }

    boolean getFilterOnName() {
        return this.filterName;
    }

    private boolean isFilteringName() {
        return this.getFilterOnName() && this.hasSearchText();
    }

    void setFilterOnDocumentation(boolean set) {
        this.filterDocumentation = set;
    }

    boolean getFilterOnDocumentation() {
        return this.filterDocumentation;
    }

    private boolean isFilteringDocumentation() {
        return this.getFilterOnDocumentation() && this.hasSearchText();
    }

    void setFilterOnPropertyValues(boolean set) {
        this.filterPropertyValues = set;
    }

    boolean getFilterOnPropertyValues() {
        return this.filterPropertyValues;
    }

    private boolean isFilteringPropertyValues() {
        return this.getFilterOnPropertyValues() && this.hasSearchText();
    }

    void addPropertyKeyFilter(String key) {
        this.propertyKeyFilter.add(key);
    }

    void removePropertyKeyFilter(String key) {
        this.propertyKeyFilter.remove(key);
    }

    Set<String> getPropertyKeyFilter() {
        return this.propertyKeyFilter;
    }

    void resetPropertyKeyFilter() {
        this.propertyKeyFilter.clear();
    }

    boolean isFilteringPropertyKeys() {
        return !this.propertyKeyFilter.isEmpty();
    }

    void addConceptFilter(EClass eClass) {
        this.conceptsFilter.add(eClass);
    }

    void removeConceptFilter(EClass eClass) {
        this.conceptsFilter.remove(eClass);
    }

    void resetConceptsFilter() {
        this.conceptsFilter.clear();
    }

    boolean isFilteringConcepts() {
        return !this.conceptsFilter.isEmpty();
    }

    void addSpecializationsFilter(IProfile profile) {
        this.specializationsFilter.add(profile);
    }

    void removeSpecializationsFilter(IProfile profile) {
        this.specializationsFilter.remove(profile);
    }

    void resetSpecializationsFilter() {
        this.specializationsFilter.clear();
    }

    boolean isFilteringSpecializations() {
        return !this.specializationsFilter.isEmpty();
    }

    void setShowAllFolders(boolean set) {
        this.showAllFolders = set;
    }

    boolean getShowAllFolders() {
        return this.showAllFolders;
    }

    void setFilterViews(boolean set) {
        this.filterViews = set;
    }

    boolean isFilteringViews() {
        return this.filterViews;
    }

    void setMatchCase(boolean set) {
        this.matchCase = set;
        this.createRegexMatcher();
    }

    boolean getMatchCase() {
        return this.matchCase;
    }

    void setUseRegex(boolean set) {
        this.useRegex = set;
        this.createRegexMatcher();
    }

    boolean getUseRegex() {
        return this.useRegex;
    }
}

