/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.search;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SearchTextWidget
extends Composite {
    private Text fTextControl;
    private Label fCancelLabel;
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String text = SearchTextWidget.this.getText();
            if ("".equals(text) && SearchTextWidget.this.fCancelLabel != null && !SearchTextWidget.this.fCancelLabel.isDisposed()) {
                SearchTextWidget.this.fCancelLabel.dispose();
                SearchTextWidget.this.fCancelLabel = null;
                SearchTextWidget.this.layout();
            } else if (SearchTextWidget.this.fCancelLabel == null) {
                SearchTextWidget.this.fCancelLabel = new Label((Composite)SearchTextWidget.this, 0);
                SearchTextWidget.this.fCancelLabel.setImage(IArchiImages.ImageFactory.getImage("img/cancelsearch.png"));
                SearchTextWidget.this.fCancelLabel.setBackground(SearchTextWidget.this.fTextControl.getBackground());
                GridData gd = new GridData(0, 4, false, true);
                SearchTextWidget.this.fCancelLabel.setLayoutData((Object)gd);
                SearchTextWidget.this.fCancelLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        (this).SearchTextWidget.this.fTextControl.setText("");
                        (this).SearchTextWidget.this.fTextControl.setFocus();
                    }
                });
                SearchTextWidget.this.layout();
            }
        }
    };

    public SearchTextWidget(Composite parent) {
        super(parent, 2048);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 0);
        label.setImage(ThemeUtils.isDarkTheme() ? IArchiImages.ImageFactory.getImage("img/search_light.png") : IArchiImages.ImageFactory.getImage("img/search.png"));
        GridData gd = new GridData(0, 4, false, true);
        label.setLayoutData((Object)gd);
        this.fTextControl = UIUtils.createSingleTextControl(this, 0, false);
        gd = new GridData(4, 4, true, true);
        this.fTextControl.setLayoutData((Object)gd);
        this.fTextControl.addModifyListener(this.fModifyListener);
        UIUtils.applyMacUndoBugFilter((Control)this.fTextControl);
        label.setBackground(this.fTextControl.getBackground());
        this.setBackground(this.fTextControl.getBackground());
    }

    public Text getTextControl() {
        return this.fTextControl;
    }

    public String getText() {
        return this.fTextControl.getText();
    }

    public void setText(String text) {
        this.fTextControl.setText(StringUtils.safeString(text));
    }
}

