/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.dialog;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.templates.dialog.Messages;
import com.archimatetool.templates.dialog.TemplateManagerDialogDragDropHandler;
import com.archimatetool.templates.dialog.TemplatesTableViewer;
import com.archimatetool.templates.dialog.TemplatesTreeViewer;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TemplateManagerDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.TemplateManagerDialog";
    protected TemplatesTableViewer fTableViewer;
    protected TemplatesTreeViewer fTreeViewer;
    protected Button fButtonAddTemplate;
    protected Button fButtonNewGroup;
    protected Button fButtonRemove;
    protected Label fFileLabel;
    protected Label fNameLabel;
    protected Label fDescriptionLabel;
    protected Text fFileTextField;
    protected Text fNameTextField;
    protected Text fDescriptionTextField;
    protected Object fSelectedControl;
    protected ITemplate fSelectedTemplate;
    protected ITemplateGroup fSelectedTemplateGroup;
    protected Set<ITemplate> fModifiedTemplates = new HashSet<ITemplate>();
    protected TemplateManager fTemplateManager;
    protected boolean fIsSettingFields;

    public TemplateManagerDialog(Shell parentShell, TemplateManager templateManager) {
        super(parentShell, "TemplateManagerDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTemplateManager = templateManager;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TemplateManagerDialog_1);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpID());
        this.setTitle(Messages.TemplateManagerDialog_2);
        this.setMessage(Messages.TemplateManagerDialog_3);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        SashForm sash = new SashForm(client, 256);
        sash.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.widthHint = 580;
        gd.heightHint = 300;
        sash.setLayoutData((Object)gd);
        Composite tableComp = new Composite((Composite)sash, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComp.setLayout((Layout)layout);
        CLabel label = new CLabel(tableComp, 0);
        label.setText(Messages.TemplateManagerDialog_4);
        Composite tableComp2 = new Composite(tableComp, 0);
        tableComp2.setLayout((Layout)new TableColumnLayout());
        tableComp2.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new TemplatesTableViewer(tableComp2, 2);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.setInput(this.fTemplateManager.getUserTemplates());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = event.getStructuredSelection().getFirstElement();
                TemplateManagerDialog.this.fSelectedControl = TemplateManagerDialog.this.fTableViewer;
                TemplateManagerDialog.this.updateControls(o);
            }
        });
        Composite treeComp = new Composite((Composite)sash, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        treeComp.setLayout((Layout)layout);
        label = new CLabel(treeComp, 0);
        label.setText(Messages.TemplateManagerDialog_5);
        this.fTreeViewer = new TemplatesTreeViewer(treeComp, 2);
        this.fTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTreeViewer.setInput(this.fTemplateManager.getUserTemplateGroups());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = event.getStructuredSelection().getFirstElement();
                TemplateManagerDialog.this.fSelectedControl = TemplateManagerDialog.this.fTreeViewer;
                TemplateManagerDialog.this.updateControls(o);
            }
        });
        new TemplateManagerDialogDragDropHandler(this.fTableViewer, this.fTreeViewer);
        Composite buttonBar = new Composite(client, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonBar.setLayout((Layout)layout);
        buttonBar.setLayoutData((Object)new GridData(2));
        this.fButtonAddTemplate = new Button(buttonBar, 0);
        this.fButtonAddTemplate.setText(Messages.TemplateManagerDialog_6);
        gd = new GridData(768);
        this.fButtonAddTemplate.setLayoutData((Object)gd);
        this.fButtonAddTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerDialog.this.openTemplate();
            }
        });
        this.fButtonNewGroup = new Button(buttonBar, 0);
        this.fButtonNewGroup.setText(Messages.TemplateManagerDialog_7);
        gd = new GridData(768);
        this.fButtonNewGroup.setLayoutData((Object)gd);
        this.fButtonNewGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerDialog.this.newGroup();
            }
        });
        this.fButtonRemove = new Button(buttonBar, 0);
        this.fButtonRemove.setText(Messages.TemplateManagerDialog_8);
        gd = new GridData(768);
        this.fButtonRemove.setLayoutData((Object)gd);
        this.fButtonRemove.setEnabled(false);
        this.fButtonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerDialog.this.deleteSelectedObjects();
            }
        });
        sash.setWeights(new int[]{30, 70});
        Composite fieldContainer = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        fieldContainer.setLayout((Layout)layout);
        fieldContainer.setLayoutData((Object)new GridData(768));
        this.fNameLabel = new Label(fieldContainer, 0);
        this.fNameLabel.setText(Messages.TemplateManagerDialog_9);
        this.fNameLabel.setEnabled(false);
        this.fNameTextField = UIUtils.createSingleTextControl((Composite)fieldContainer, (int)2048, (boolean)false);
        this.fNameTextField.setLayoutData((Object)new GridData(768));
        this.fNameTextField.setEnabled(false);
        this.fNameTextField.addModifyListener(e -> {
            String text = this.fNameTextField.getText();
            if (this.fIsSettingFields || !StringUtils.isSet((String)text)) {
                return;
            }
            if (this.fSelectedTemplate != null) {
                this.fSelectedTemplate.setName(text);
                this.fModifiedTemplates.add(this.fSelectedTemplate);
                this.fTableViewer.refresh();
                this.fTreeViewer.refresh();
            } else if (this.fSelectedTemplateGroup != null) {
                this.fSelectedTemplateGroup.setName(text);
                this.fTreeViewer.refresh();
            }
        });
        this.fDescriptionLabel = new Label(fieldContainer, 0);
        this.fDescriptionLabel.setText(Messages.TemplateManagerDialog_10);
        this.fDescriptionLabel.setEnabled(false);
        this.fDescriptionTextField = new Text(fieldContainer, 2626);
        this.fDescriptionTextField.setEnabled(false);
        gd = new GridData(1808);
        gd.heightHint = 100;
        this.fDescriptionTextField.setLayoutData((Object)gd);
        this.fDescriptionTextField.addModifyListener(e -> {
            String text = this.fDescriptionTextField.getText();
            if (this.fIsSettingFields || !StringUtils.isSet((String)text)) {
                return;
            }
            if (this.fSelectedTemplate != null) {
                this.fSelectedTemplate.setDescription(this.fDescriptionTextField.getText());
                this.fModifiedTemplates.add(this.fSelectedTemplate);
            }
        });
        this.fFileLabel = new Label(fieldContainer, 0);
        this.fFileLabel.setText(Messages.TemplateManagerDialog_11);
        this.fFileLabel.setEnabled(false);
        this.fFileTextField = new Text(fieldContainer, 2060);
        this.fFileTextField.setLayoutData((Object)new GridData(768));
        this.fFileTextField.setEnabled(false);
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
        BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
            try {
                try {
                    this.fTemplateManager.saveUserTemplatesManifest();
                    for (ITemplate template : this.fModifiedTemplates) {
                        template.save();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    MessageDialog.openError(null, (String)Messages.TemplateManagerDialog_12, (String)ex.getMessage());
                    this.fTemplateManager.dispose();
                }
            }
            finally {
                this.fTemplateManager.dispose();
            }
        });
    }

    protected void cancelPressed() {
        this.fTemplateManager.dispose();
        super.cancelPressed();
    }

    protected void openTemplate() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.TemplateManagerDialog_13);
        dialog.setFilterExtensions(new String[]{"*" + this.fTemplateManager.getTemplateFileExtension(), "*.*"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (this.hasUserTemplate(file)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.TemplateManagerDialog_16, (String)Messages.TemplateManagerDialog_17);
            return;
        }
        BusyIndicator.showWhile(null, () -> {
            try {
                this.fTemplateManager.addUserTemplate(this.fTemplateManager.createTemplate(file));
                this.fTableViewer.refresh();
            }
            catch (IOException ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TemplateManagerDialog_18, (String)ex.getMessage());
            }
        });
    }

    protected void newGroup() {
        String name;
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                return "".equals(newText) ? "" : (this.hasGroup(newText) ? Messages.TemplateManagerDialog_21 : null);
            }

            boolean hasGroup(String name) {
                for (ITemplateGroup group : TemplateManagerDialog.this.fTemplateManager.getUserTemplateGroups()) {
                    if (!name.equals(group.getName())) continue;
                    return true;
                }
                return false;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.TemplateManagerDialog_22, Messages.TemplateManagerDialog_23, "", validator);
        if (dialog.open() == 0 && StringUtils.isSetAfterTrim((String)(name = dialog.getValue()))) {
            TemplateGroup group = new TemplateGroup(name);
            this.fTemplateManager.getUserTemplateGroups().add(group);
            this.fTreeViewer.refresh();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)group), true);
        }
    }

    protected void deleteSelectedObjects() {
        if (this.fSelectedControl == this.fTableViewer) {
            Object[] objectArray = this.fTableViewer.getStructuredSelection().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ITemplate) {
                    ITemplate template = (ITemplate)o;
                    this.fTemplateManager.getUserTemplates().remove(template);
                    for (ITemplateGroup group : this.fTemplateManager.getUserTemplateGroups()) {
                        group.removeTemplate(template);
                    }
                }
                ++n2;
            }
            this.fTableViewer.refresh();
            this.fTreeViewer.refresh();
        } else if (this.fSelectedControl == this.fTreeViewer) {
            TreeItem[] treeItemArray = this.fTreeViewer.getTree().getSelection();
            int n = treeItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem item = treeItemArray[n3];
                Object object = item.getData();
                if (object instanceof ITemplate) {
                    ITemplate template = (ITemplate)object;
                    TreeItem parent = item.getParentItem();
                    Object object2 = parent.getData();
                    if (object2 instanceof ITemplateGroup) {
                        ITemplateGroup group = (ITemplateGroup)object2;
                        group.removeTemplate(template);
                    }
                } else {
                    Object object3 = item.getData();
                    if (object3 instanceof ITemplateGroup) {
                        ITemplateGroup group = (ITemplateGroup)object3;
                        this.fTemplateManager.getUserTemplateGroups().remove(group);
                    }
                }
                ++n3;
            }
            this.fTreeViewer.refresh();
        }
    }

    protected void updateControls(Object o) {
        this.fIsSettingFields = true;
        this.fNameLabel.setEnabled(o instanceof ITemplate || o instanceof ITemplateGroup);
        this.fDescriptionLabel.setEnabled(o instanceof ITemplate);
        this.fFileLabel.setEnabled(o instanceof ITemplate);
        this.fNameTextField.setText("");
        this.fDescriptionTextField.setText("");
        this.fFileTextField.setText("");
        this.fNameTextField.setEnabled(o instanceof ITemplate || o instanceof ITemplateGroup);
        this.fDescriptionTextField.setEnabled(o instanceof ITemplate);
        this.fButtonRemove.setEnabled(o instanceof ITemplate || o instanceof ITemplateGroup);
        if (o instanceof ITemplate) {
            ITemplate template;
            this.fSelectedTemplate = template = (ITemplate)o;
            this.fSelectedTemplateGroup = null;
            this.fNameTextField.setText(StringUtils.safeString((String)this.fSelectedTemplate.getName()));
            this.fDescriptionTextField.setText(StringUtils.safeString((String)this.fSelectedTemplate.getDescription()));
            this.fFileTextField.setText(StringUtils.safeString((String)this.fSelectedTemplate.getFile().getAbsolutePath()));
        } else if (o instanceof ITemplateGroup) {
            ITemplateGroup group = (ITemplateGroup)o;
            this.fSelectedTemplate = null;
            this.fSelectedTemplateGroup = group;
            this.fNameTextField.setText(StringUtils.safeString((String)this.fSelectedTemplateGroup.getName()));
        }
        this.fIsSettingFields = false;
    }

    protected boolean hasUserTemplate(File file) {
        if (file == null) {
            return false;
        }
        for (ITemplate template : this.fTemplateManager.getUserTemplates()) {
            if (!file.equals(template.getFile())) continue;
            return true;
        }
        return false;
    }

    protected String getHelpID() {
        return HELP_ID;
    }
}

