/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.dialog;

import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class TemplateManagerDialogDragDropHandler {
    private TreeViewer fTreeViewer;
    private int fDragOperations = 1;
    Transfer[] sourceTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};

    public TemplateManagerDialogDragDropHandler(TableViewer tableViewer, TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
        this.registerDragSupport((StructuredViewer)tableViewer);
        this.registerDropSupport((StructuredViewer)treeViewer);
    }

    private void registerDragSupport(final StructuredViewer viewer) {
        viewer.addDragSupport(this.fDragOperations, this.sourceTransferTypes, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(viewer.getSelection());
                event.doit = true;
            }
        });
    }

    private void registerDropSupport(StructuredViewer viewer) {
        viewer.addDropSupport(this.fDragOperations, this.sourceTransferTypes, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
                event.feedback |= 0x18;
            }

            public void drop(DropTargetEvent event) {
                TemplateManagerDialogDragDropHandler.this.doDropOperation(event);
            }

            public void dropAccept(DropTargetEvent event) {
            }

            private int getEventDetail(DropTargetEvent event) {
                return TemplateManagerDialogDragDropHandler.this.isValidSelection() && TemplateManagerDialogDragDropHandler.this.isValidDropTarget(event) ? 1 : 0;
            }
        });
    }

    private void doDropOperation(DropTargetEvent event) {
        Object parent = this.getTargetParent(event);
        if (parent instanceof ITemplateGroup) {
            this.copy((ITemplateGroup)parent);
        }
    }

    private void copy(ITemplateGroup parent) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ITemplate && !parent.getTemplates().contains(o)) {
                parent.addTemplate((ITemplate)o);
            }
            ++n2;
        }
        this.fTreeViewer.refresh();
    }

    private boolean isValidSelection() {
        return true;
    }

    private Object getTargetParent(DropTargetEvent event) {
        if (event.item == null) {
            return null;
        }
        Object objectDroppedOn = event.item.getData();
        if (objectDroppedOn instanceof ITemplateGroup) {
            return objectDroppedOn;
        }
        return null;
    }

    private boolean isValidDropTarget(DropTargetEvent event) {
        Object parent = this.getTargetParent(event);
        if (parent instanceof ITemplateGroup) {
            ITemplateGroup targetGroup = (ITemplateGroup)parent;
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            for (Object object : selection.toList()) {
                if (!targetGroup.getTemplates().contains(object)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

