/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.impl.wizard;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.services.UIRequest;
import com.archimatetool.editor.ui.services.UIRequestManager;
import com.archimatetool.editor.utils.ZipUtils;
import com.archimatetool.editor.views.tree.TreeEditElementRequest;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.util.UUIDFactory;
import com.archimatetool.templates.impl.model.ArchimateTemplateManager;
import com.archimatetool.templates.impl.wizard.Messages;
import com.archimatetool.templates.impl.wizard.NewArchimateModelFromTemplateWizardPage;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.TemplateManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewArchimateModelFromTemplateWizard
extends Wizard {
    private NewArchimateModelFromTemplateWizardPage fMainPage;
    private TemplateManager fTemplateManager;
    private ITemplate fSelectedTemplate;

    public NewArchimateModelFromTemplateWizard() {
        this.setWindowTitle(Messages.NewArchimateModelFromTemplateWizard_0);
        this.fTemplateManager = new ArchimateTemplateManager();
    }

    public void addPages() {
        this.fMainPage = new NewArchimateModelFromTemplateWizardPage(this.fTemplateManager);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        this.fSelectedTemplate = this.fMainPage.getSelectedTemplate();
        return this.fSelectedTemplate != null;
    }

    public IArchimateModel createNewModel() throws IOException {
        File file = this.getTempModelFile();
        if (file == null || !file.exists()) {
            return null;
        }
        IArchimateModel model = IEditorModelManager.INSTANCE.openModel(file);
        if (model != null) {
            model.setName(Messages.NewArchimateModelFromTemplateWizard_1 + " " + model.getName());
            model.setVersion("5.0.0");
            model.setFile(null);
            UUIDFactory.generateNewIDs((EObject)model);
            UIRequestManager.INSTANCE.fireRequestAsync((UIRequest)new TreeEditElementRequest((Object)this, (Object)model));
        }
        file.delete();
        return model;
    }

    private File getTempModelFile() throws IOException {
        if (this.fSelectedTemplate == null) {
            return null;
        }
        File zipFile = this.fSelectedTemplate.getFile();
        File tmpFile = File.createTempFile("~architemplate", null);
        tmpFile.deleteOnExit();
        return ZipUtils.extractZipEntry((File)zipFile, (String)"model.archimate", (File)tmpFile);
    }

    public void dispose() {
        super.dispose();
        this.fTemplateManager.dispose();
    }
}

