/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.impl.wizard;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.ModelChecker;
import com.archimatetool.editor.utils.ZipUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.util.UUIDFactory;
import com.archimatetool.templates.impl.model.ArchimateModelTemplate;
import com.archimatetool.templates.impl.model.ArchimateTemplateManager;
import com.archimatetool.templates.impl.wizard.Messages;
import com.archimatetool.templates.impl.wizard.SaveArchimateModelAsTemplateToCollectionWizardPage;
import com.archimatetool.templates.impl.wizard.SaveArchimateModelAsTemplateWizardPage;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import com.archimatetool.templates.wizard.SaveModelAsTemplateToCollectionWizardPage;
import com.archimatetool.templates.wizard.TemplateUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveArchimateModelAsTemplateWizard
extends Wizard {
    private IArchimateModel fModel;
    private SaveArchimateModelAsTemplateWizardPage fPage1;
    private SaveModelAsTemplateToCollectionWizardPage fPage2;
    private File fZipFile;
    private String fTemplateName;
    private String fTemplateDescription;
    private boolean fIncludeThumbnails;
    private IDiagramModel fSelectedDiagramModel;
    private ITemplateGroup fSelectedTemplateGroup;
    private boolean fDoStoreInCollection;
    private TemplateManager fTemplateManager;

    public SaveArchimateModelAsTemplateWizard(IArchimateModel model) {
        this.setWindowTitle(Messages.SaveArchimateModelAsTemplateWizard_0);
        this.fModel = model;
        this.fTemplateManager = new ArchimateTemplateManager();
    }

    public void addPages() {
        this.fPage1 = new SaveArchimateModelAsTemplateWizardPage(this.fModel, this.fTemplateManager);
        this.addPage((IWizardPage)this.fPage1);
        this.fPage2 = new SaveArchimateModelAsTemplateToCollectionWizardPage(this.fTemplateManager);
        this.addPage((IWizardPage)this.fPage2);
    }

    public boolean performFinish() {
        boolean result;
        this.fPage1.storePreferences();
        this.fZipFile = new File(this.fPage1.getFileName());
        if (this.fZipFile.exists() && !(result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.SaveArchimateModelAsTemplateWizard_1, (String)NLS.bind((String)Messages.SaveArchimateModelAsTemplateWizard_2, (Object)this.fZipFile.getPath())))) {
            return false;
        }
        this.fTemplateName = this.fPage1.getTemplateName();
        this.fTemplateDescription = this.fPage1.getTemplateDescription();
        this.fIncludeThumbnails = this.fPage1.includeThumbnails();
        this.fSelectedDiagramModel = this.fPage1.getSelectedDiagramModel();
        this.fDoStoreInCollection = this.fPage2.doStoreInCollection();
        this.fSelectedTemplateGroup = this.fPage2.getTemplateGroup();
        BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
            try {
                this.createZipFile(this.fZipFile);
                if (this.fDoStoreInCollection) {
                    this.fTemplateManager.addTemplateEntry(this.fZipFile, this.fSelectedTemplateGroup);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.fZipFile.delete();
                Display.getCurrent().asyncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)Messages.SaveArchimateModelAsTemplateWizard_3, (String)ex.getMessage()));
            }
        });
        return true;
    }

    private void createZipFile(File zipFile) throws IOException {
        File parent = zipFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream zOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            String manifest = this.createManifest();
            ZipUtils.addStringToZip((String)manifest, (String)"manifest.xml", (ZipOutputStream)zOut, (Charset)Charset.forName("UTF-8"));
            if (this.fIncludeThumbnails) {
                int count = 2;
                for (IDiagramModel dm : this.fModel.getDiagramModels()) {
                    int index = -1;
                    if (this.fSelectedDiagramModel == dm) {
                        index = 1;
                    } else if (count <= 50) {
                        index = count++;
                    }
                    if (index == -1) continue;
                    Image image = TemplateUtils.createThumbnailImage(dm);
                    ZipUtils.addImageToZip((Image)image, (String)("Thumbnails/" + index + ".png"), (ZipOutputStream)zOut, (int)5, null);
                    image.dispose();
                }
            }
            File tempFile = this.saveModelToTempFile();
            ZipUtils.addFileToZip((File)tempFile, (String)"model.archimate", (ZipOutputStream)zOut);
            tempFile.delete();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String createManifest() throws IOException {
        ArchimateModelTemplate template = new ArchimateModelTemplate();
        template.setName(this.fTemplateName);
        template.setDescription(this.fTemplateDescription);
        if (this.fIncludeThumbnails) {
            template.setKeyThumbnailPath("Thumbnails/1.png");
        }
        return template.createManifest();
    }

    private File saveModelToTempFile() throws IOException {
        File tmpFile = File.createTempFile("architemplate", null);
        tmpFile.deleteOnExit();
        IArchimateModel tempModel = (IArchimateModel)EcoreUtil.copy((EObject)this.fModel);
        tempModel.setFile(tmpFile);
        UUIDFactory.generateNewIDs((EObject)tempModel);
        ModelChecker mc = new ModelChecker(tempModel);
        if (!mc.checkAll()) {
            mc.logErrorMesssages();
            throw new IOException(Messages.SaveArchimateModelAsTemplateWizard_4);
        }
        IArchiveManager archiveManager = ((IArchiveManager)this.fModel.getAdapter(IArchiveManager.class)).clone(tempModel);
        tempModel.setAdapter(IArchiveManager.class, (Object)archiveManager);
        archiveManager.saveModel();
        return tmpFile;
    }

    public void dispose() {
        super.dispose();
        this.fTemplateManager.dispose();
        this.fTemplateManager = null;
        this.fModel = null;
        this.fSelectedDiagramModel = null;
    }
}

