/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.model;

import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TemplateGroup
implements ITemplateGroup {
    private List<ITemplate> fTemplates = new ArrayList<ITemplate>();
    private String fName;

    public TemplateGroup() {
    }

    public TemplateGroup(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public List<ITemplate> getTemplates() {
        return this.fTemplates;
    }

    @Override
    public void addTemplate(ITemplate template) {
        this.fTemplates.add(template);
    }

    @Override
    public boolean removeTemplate(ITemplate template) {
        return this.fTemplates.remove(template);
    }

    @Override
    public List<ITemplate> getSortedTemplates() {
        ArrayList<ITemplate> list = new ArrayList<ITemplate>(this.getTemplates());
        Collections.sort(list, new Comparator<ITemplate>(){

            @Override
            public int compare(ITemplate t1, ITemplate t2) {
                String name1 = StringUtils.safeString((String)t1.getName()).toLowerCase().trim();
                String name2 = StringUtils.safeString((String)t2.getName()).toLowerCase().trim();
                return name1.compareTo(name2);
            }
        });
        return list;
    }
}

