/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.wizard;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import com.archimatetool.templates.wizard.Messages;
import com.archimatetool.templates.wizard.TemplateGroupsTableViewer;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class SaveModelAsTemplateToCollectionWizardPage
extends WizardPage {
    protected Button fDoStoreInCollectionButton;
    protected TemplateGroupsTableViewer fCategoriesTableViewer;
    protected Button fNewGroupButton;
    protected TemplateManager fTemplateManager;
    protected ITemplateGroup fSelectedTemplateGroup;

    public SaveModelAsTemplateToCollectionWizardPage(String pageName, TemplateManager templateManager) {
        super(pageName);
        this.fTemplateManager = templateManager;
        this.init();
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/new_wiz.png"));
    }

    protected abstract void init();

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, this.getHelpID());
        this.fDoStoreInCollectionButton = new Button(container, 32);
        this.fDoStoreInCollectionButton.setText(Messages.SaveModelAsTemplateToCollectionWizardPage_0);
        this.fDoStoreInCollectionButton.setSelection(true);
        this.fDoStoreInCollectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = SaveModelAsTemplateToCollectionWizardPage.this.fDoStoreInCollectionButton.getSelection();
                SaveModelAsTemplateToCollectionWizardPage.this.fCategoriesTableViewer.getControl().setEnabled(enabled);
                SaveModelAsTemplateToCollectionWizardPage.this.fNewGroupButton.setEnabled(enabled);
                if (enabled) {
                    Object o = SaveModelAsTemplateToCollectionWizardPage.this.fCategoriesTableViewer.getElementAt(0);
                    if (o != null) {
                        SaveModelAsTemplateToCollectionWizardPage.this.fCategoriesTableViewer.setSelection((ISelection)new StructuredSelection(o));
                    }
                } else {
                    SaveModelAsTemplateToCollectionWizardPage.this.fCategoriesTableViewer.setSelection((ISelection)new StructuredSelection());
                }
            }
        });
        Label label = new Label(container, 0);
        label.setText(Messages.SaveModelAsTemplateToCollectionWizardPage_1);
        Composite fieldContainer = new Composite(container, 0);
        fieldContainer.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        fieldContainer.setLayout((Layout)layout);
        Composite tableComp = new Composite(fieldContainer, 0);
        tableComp.setLayout((Layout)new TableColumnLayout());
        GridData gd = new GridData(1808);
        gd.heightHint = 120;
        tableComp.setLayoutData((Object)gd);
        this.fCategoriesTableViewer = new TemplateGroupsTableViewer(tableComp, 2050);
        this.fCategoriesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SaveModelAsTemplateToCollectionWizardPage.this.fSelectedTemplateGroup = (ITemplateGroup)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        this.fCategoriesTableViewer.setInput(this.fTemplateManager.getUserTemplateGroups());
        this.fNewGroupButton = new Button(fieldContainer, 0);
        this.fNewGroupButton.setText(Messages.SaveModelAsTemplateToCollectionWizardPage_2);
        gd = new GridData(128, 128, false, false);
        this.fNewGroupButton.setLayoutData((Object)gd);
        this.fNewGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        return "".equals(newText) ? "" : (this.hasGroup(newText) ? Messages.SaveModelAsTemplateToCollectionWizardPage_3 : null);
                    }

                    boolean hasGroup(String name) {
                        for (ITemplateGroup group : (this).SaveModelAsTemplateToCollectionWizardPage.this.fTemplateManager.getUserTemplateGroups()) {
                            if (!name.equals(group.getName())) continue;
                            return true;
                        }
                        return false;
                    }
                };
                InputDialog dialog = new InputDialog(SaveModelAsTemplateToCollectionWizardPage.this.getShell(), Messages.SaveModelAsTemplateToCollectionWizardPage_4, Messages.SaveModelAsTemplateToCollectionWizardPage_5, "", validator);
                if (dialog.open() == 0 && StringUtils.isSetAfterTrim((String)(name = dialog.getValue()))) {
                    TemplateGroup group = new TemplateGroup(name);
                    SaveModelAsTemplateToCollectionWizardPage.this.fTemplateManager.getUserTemplateGroups().add(group);
                    SaveModelAsTemplateToCollectionWizardPage.this.fCategoriesTableViewer.refresh();
                    SaveModelAsTemplateToCollectionWizardPage.this.fCategoriesTableViewer.setSelection((ISelection)new StructuredSelection((Object)group), true);
                }
            }
        });
        this.setPageComplete(true);
    }

    public boolean doStoreInCollection() {
        return this.fDoStoreInCollectionButton.getSelection();
    }

    public ITemplateGroup getTemplateGroup() {
        return this.fSelectedTemplateGroup;
    }

    protected abstract String getHelpID();
}

