/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.wizard;

import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.model.IDiagramModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class TemplateUtils {
    public static void createThumbnailPreviewImage(IDiagramModel diagramModel, Label label) {
        if (label.getImage() != null) {
            label.getImage().dispose();
            label.setImage(null);
        }
        Shell shell = new Shell();
        GraphicalViewerImpl diagramViewer = DiagramUtils.createViewer((IDiagramModel)diagramModel, (Composite)shell);
        Rectangle bounds = DiagramUtils.getDiagramExtents((GraphicalViewer)diagramViewer);
        bounds.expand(10, 10);
        double ratio = Math.min(1.0, Math.min((double)label.getBounds().width / (double)bounds.width, (double)label.getBounds().height / (double)bounds.height));
        Image image = DiagramUtils.createImage((GraphicalViewer)diagramViewer, (double)ratio, (int)5);
        label.setImage(image);
        shell.dispose();
    }

    public static Image createThumbnailImage(IDiagramModel diagramModel) {
        Shell shell = new Shell();
        GraphicalViewerImpl diagramViewer = DiagramUtils.createViewer((IDiagramModel)diagramModel, (Composite)shell);
        int padding = 5;
        Rectangle bounds = DiagramUtils.getDiagramExtents((GraphicalViewer)diagramViewer);
        bounds.expand(padding * 2, padding * 2);
        double ratio = Math.min(1.0, Math.min(512.0 / (double)bounds.width, 512.0 / (double)bounds.height));
        Image image = DiagramUtils.createImage((GraphicalViewer)diagramViewer, (double)ratio, (int)padding);
        shell.dispose();
        GC gc = new GC((Drawable)image);
        gc.setForeground(new Color(64, 64, 64));
        gc.drawRectangle(0, 0, image.getBounds().width - 1, image.getBounds().height - 1);
        gc.dispose();
        return image;
    }
}

