/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation;

import com.archimatetool.hammer.ArchiHammerPlugin;
import com.archimatetool.hammer.validation.checkers.DuplicateElementChecker;
import com.archimatetool.hammer.validation.checkers.EmptyViewsChecker;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.InvalidRelationsChecker;
import com.archimatetool.hammer.validation.checkers.JunctionsChecker;
import com.archimatetool.hammer.validation.checkers.NestedElementsChecker;
import com.archimatetool.hammer.validation.checkers.UnusedElementsChecker;
import com.archimatetool.hammer.validation.checkers.UnusedRelationsChecker;
import com.archimatetool.hammer.validation.checkers.ViewpointChecker;
import com.archimatetool.hammer.validation.issues.AbstractIssueCategory;
import com.archimatetool.hammer.validation.issues.AdviceCategory;
import com.archimatetool.hammer.validation.issues.AdviceType;
import com.archimatetool.hammer.validation.issues.ErrorType;
import com.archimatetool.hammer.validation.issues.ErrorsCategory;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.validation.issues.OKType;
import com.archimatetool.hammer.validation.issues.WarningType;
import com.archimatetool.hammer.validation.issues.WarningsCategory;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateRelationship;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;

public class Validator {
    private IArchimateModel fModel;
    private List<IArchimateElement> fElements;
    private List<IArchimateRelationship> fRelations;
    private List<IArchimateDiagramModel> fViews;
    private List<ErrorType> fErrorList;
    private List<WarningType> fWarningList;
    private List<AdviceType> fAdviceList;

    public Validator(IArchimateModel model) {
        this.fModel = model;
    }

    public List<Object> validate() {
        AbstractIssueCategory category;
        if (this.fModel == null) {
            return null;
        }
        this.fElements = new ArrayList<IArchimateElement>();
        this.fRelations = new ArrayList<IArchimateRelationship>();
        this.fViews = new ArrayList<IArchimateDiagramModel>();
        TreeIterator iter = this.fModel.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof IArchimateRelationship) {
                this.fRelations.add((IArchimateRelationship)eObject);
                continue;
            }
            if (eObject instanceof IArchimateElement) {
                this.fElements.add((IArchimateElement)eObject);
                continue;
            }
            if (!(eObject instanceof IArchimateDiagramModel)) continue;
            this.fViews.add((IArchimateDiagramModel)eObject);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.fErrorList = new ArrayList<ErrorType>();
        this.fWarningList = new ArrayList<WarningType>();
        this.fAdviceList = new ArrayList<AdviceType>();
        IPreferenceStore store = ArchiHammerPlugin.getInstance().getPreferenceStore();
        if (store.getBoolean("checkInvalidRelations")) {
            this.collectIssues(new InvalidRelationsChecker(this.getArchimateRelationships()));
        }
        if (store.getBoolean("checkUnusedElements")) {
            this.collectIssues(new UnusedElementsChecker(this.getArchimateElements()));
        }
        if (store.getBoolean("checkUnusedRelations")) {
            this.collectIssues(new UnusedRelationsChecker(this.getArchimateRelationships()));
        }
        if (store.getBoolean("checkEmptyViews")) {
            this.collectIssues(new EmptyViewsChecker(this.getArchimateViews()));
        }
        if (store.getBoolean("checkViewpoint")) {
            this.collectIssues(new ViewpointChecker(this.getArchimateViews()));
        }
        if (store.getBoolean("checkNesting")) {
            this.collectIssues(new NestedElementsChecker(this.getArchimateViews()));
        }
        if (store.getBoolean("checkDuplicateElements")) {
            this.collectIssues(new DuplicateElementChecker(this.getArchimateElements()));
        }
        if (store.getBoolean("checkJunctions")) {
            this.collectIssues(new JunctionsChecker(this.getArchimateElements()));
        }
        if (!this.fErrorList.isEmpty()) {
            category = new ErrorsCategory(this.fErrorList);
            result.add(category);
        }
        if (!this.fWarningList.isEmpty()) {
            category = new WarningsCategory(this.fWarningList);
            result.add(category);
        }
        if (!this.fAdviceList.isEmpty()) {
            category = new AdviceCategory(this.fAdviceList);
            result.add(category);
        }
        if (result.isEmpty()) {
            result.add(new OKType());
        }
        return result;
    }

    void collectIssues(IChecker checker) {
        for (IIssue issue : checker.getIssues()) {
            if (issue instanceof ErrorType) {
                this.fErrorList.add((ErrorType)issue);
            }
            if (issue instanceof WarningType) {
                this.fWarningList.add((WarningType)issue);
            }
            if (!(issue instanceof AdviceType)) continue;
            this.fAdviceList.add((AdviceType)issue);
        }
    }

    public IArchimateModel getModel() {
        return this.fModel;
    }

    public List<IArchimateElement> getArchimateElements() {
        return new ArrayList<IArchimateElement>(this.fElements);
    }

    public List<IArchimateRelationship> getArchimateRelationships() {
        return new ArrayList<IArchimateRelationship>(this.fRelations);
    }

    public List<IArchimateDiagramModel> getArchimateViews() {
        return new ArrayList<IArchimateDiagramModel>(this.fViews);
    }
}

