/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.AdviceType;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.model.IArchimateDiagramModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class EmptyViewsChecker
implements IChecker {
    final String fName = Messages.EmptyViewsChecker_0;
    final String fDescription = Messages.EmptyViewsChecker_1;
    final String fExplanation = Messages.EmptyViewsChecker_2 + Messages.EmptyViewsChecker_3;
    private List<IArchimateDiagramModel> fViews;

    public EmptyViewsChecker(List<IArchimateDiagramModel> views) {
        this.fViews = views;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findEmptyViews();
    }

    List<IIssue> findEmptyViews() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        for (IArchimateDiagramModel view : this.fViews) {
            if (!view.getChildren().isEmpty()) continue;
            String viewName = ArchiLabelProvider.INSTANCE.getLabel((Object)view);
            String description = NLS.bind((String)this.fDescription, (Object)viewName);
            String explanation = NLS.bind((String)this.fExplanation, (Object)viewName);
            AdviceType issue = new AdviceType(this.fName, description, explanation, view);
            issues.add(issue);
        }
        return issues;
    }
}

