/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.validation.issues.WarningType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class UnusedElementsChecker
implements IChecker {
    final String NAME = Messages.UnusedElementsChecker_0;
    final String DESCRIPTION = Messages.UnusedElementsChecker_1;
    final String EXPLANATION = Messages.UnusedElementsChecker_2 + Messages.UnusedElementsChecker_3;
    private List<IArchimateElement> fArchimateElements;

    public UnusedElementsChecker(List<IArchimateElement> archimateElements) {
        this.fArchimateElements = archimateElements;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findUnusedElements();
    }

    List<IIssue> findUnusedElements() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        for (IArchimateElement element : this.fArchimateElements) {
            if (DiagramModelUtils.isArchimateConceptReferencedInDiagrams((IArchimateConcept)element)) continue;
            String name = ArchiLabelProvider.INSTANCE.getLabel((Object)element);
            String description = NLS.bind((String)this.DESCRIPTION, (Object)name);
            String explanation = NLS.bind((String)this.EXPLANATION, (Object)name);
            WarningType issue = new WarningType(this.NAME, description, explanation, element);
            issues.add(issue);
        }
        return issues;
    }
}

