/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.validation.issues.WarningType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateRelationship;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class UnusedRelationsChecker
implements IChecker {
    final String NAME = Messages.UnusedRelationsChecker_0;
    final String DESCRIPTION = Messages.UnusedRelationsChecker_1;
    final String EXPLANATION = Messages.UnusedRelationsChecker_2 + Messages.UnusedRelationsChecker_3;
    private List<IArchimateRelationship> fRelations;

    public UnusedRelationsChecker(List<IArchimateRelationship> relations) {
        this.fRelations = relations;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findUnusedRelations();
    }

    List<IIssue> findUnusedRelations() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        for (IArchimateRelationship relation : this.fRelations) {
            if (DiagramModelUtils.isArchimateConceptReferencedInDiagrams((IArchimateConcept)relation)) continue;
            String name = ArchiLabelProvider.INSTANCE.getLabel((Object)relation);
            String description = NLS.bind((String)this.DESCRIPTION, (Object)name);
            String explanation = NLS.bind((String)this.EXPLANATION, (Object)name);
            WarningType issue = new WarningType(this.NAME, description, explanation, relation);
            issues.add(issue);
        }
        return issues;
    }
}

