/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;

public abstract class PrintOperation {
    private GC printerGC;
    private Insets printMargin = new Insets(0, 0, 0, 0);
    private Printer printer;
    private ScaledGraphics printerGraphics;
    private SWTGraphics g;
    private boolean useScaledGraphics = true;

    public PrintOperation() {
    }

    public PrintOperation(Printer p) {
        this.setPrinter(p);
    }

    public void setUseScaledGraphics(boolean useScaledGraphics) {
        this.useScaledGraphics = useScaledGraphics;
    }

    protected void cleanup() {
        if (this.g != null) {
            this.g.dispose();
        }
        if (this.printerGraphics != null) {
            this.printerGraphics.dispose();
        }
        if (this.printerGC != null) {
            this.printerGC.dispose();
        }
    }

    protected Graphics getFreshPrinterGraphics() {
        if (this.printerGraphics != null) {
            this.printerGraphics.dispose();
        }
        if (this.g != null) {
            this.g.dispose();
        }
        this.g = new SWTGraphics(this.printerGC);
        if (this.useScaledGraphics) {
            this.printerGraphics = new PrinterGraphics(this.g, this.printer);
            this.setupGraphicsForPage(this.printerGraphics);
            return this.printerGraphics;
        }
        this.setupGraphicsForPage(this.g);
        return this.g;
    }

    int getGraphicsOrientation() {
        return 0x2000000;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public Rectangle getPrintRegion() {
        org.eclipse.swt.graphics.Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        Point printerDPI = this.printer.getDPI();
        Insets notAvailable = new Insets(-trim.y, -trim.x, trim.height + trim.y, trim.width + trim.x);
        Insets userPreferred = new Insets(this.printMargin.top * printerDPI.x / 72, this.printMargin.left * printerDPI.x / 72, this.printMargin.bottom * printerDPI.x / 72, this.printMargin.right * printerDPI.x / 72);
        Rectangle paperBounds = new Rectangle(this.printer.getBounds());
        Rectangle printRegion = paperBounds.getShrinked(notAvailable);
        printRegion.intersect(paperBounds.getShrinked(userPreferred));
        printRegion.translate(trim.x, trim.y);
        return printRegion;
    }

    protected void preparePrintSource() {
    }

    protected abstract void printPages();

    protected void restorePrintSource() {
    }

    public void run(String jobName) {
        this.preparePrintSource();
        if (this.printer.startJob(jobName)) {
            this.printerGC = new GC((Drawable)this.getPrinter(), this.getGraphicsOrientation());
            this.printPages();
            this.printer.endJob();
        }
        this.restorePrintSource();
        this.cleanup();
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void setPrintMargin(Insets margin) {
        this.printMargin = margin;
    }

    protected void setupGraphicsForPage(Graphics g) {
        Rectangle printRegion = this.getPrintRegion();
        g.clipRect(printRegion);
        g.translate(printRegion.getTopLeft());
    }
}

