/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelImageProvider;
import com.archimatetool.model.IFolder;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.StatusMessage;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;

abstract class AbstractImporter {
    private ModelImporter importer;

    protected AbstractImporter(ModelImporter importer) {
        this.importer = importer;
    }

    protected boolean shouldUpdate() {
        return this.importer.shouldUpdate();
    }

    protected boolean shouldUpdateAll() {
        return this.importer.shouldUpdateAll();
    }

    protected boolean shouldUpdateFolderStructure() {
        return this.importer.shouldUpdateFolderStructure();
    }

    protected <T extends EObject> T findObjectInTargetModel(T eObject) throws ImportException {
        return this.importer.findObjectInTargetModel(eObject);
    }

    protected <T extends IArchimateModelObject> T cloneObject(T eObject) {
        return this.importer.cloneObject(eObject);
    }

    protected void updateObject(EObject source, EObject target) {
        this.importer.updateObject(source, target);
    }

    protected IArchimateModel getImportedModel() {
        return this.importer.getImportedModel();
    }

    protected IArchimateModel getTargetModel() {
        return this.importer.getTargetModel();
    }

    protected void addCommand(Command cmd) {
        this.importer.addCommand(cmd);
    }

    protected void logMessage(StatusMessage.StatusMessageLevel level, String message, Object ... objs) {
        this.importer.logMessage(level, message, objs);
    }

    protected void addToParentFolder(IArchimateModelObject importedObject, IArchimateModelObject targetObject) throws ImportException {
        IFolder importedParentFolder = (IFolder)importedObject.eContainer();
        if (targetObject.eContainer() != null && !this.shouldUpdateFolderStructure()) {
            return;
        }
        if (importedParentFolder.getType() == FolderType.USER) {
            IFolder targetParentFolder = this.importer.findObjectInTargetModel(importedParentFolder);
            if (targetParentFolder != null) {
                this.addCommand(new AddObjectCommand(targetParentFolder, targetObject));
            } else if (!(importedObject instanceof IArchimateRelationship)) {
                throw new ImportException("Target parent folder was null");
            }
        } else {
            IFolder targetParentFolder = this.getTargetModel().getDefaultFolderForObject((EObject)targetObject);
            this.addCommand(new AddObjectCommand(targetParentFolder, targetObject));
        }
    }

    protected void importImageBytes(IDiagramModelImageProvider importedObject, IDiagramModelImageProvider targetObject) throws IOException {
        String importedImagePath = importedObject.getImagePath();
        if (importedImagePath != null) {
            IArchiveManager importedArchiveManager = (IArchiveManager)this.getImportedModel().getAdapter(IArchiveManager.class);
            IArchiveManager targetArchiveManager = (IArchiveManager)this.getTargetModel().getAdapter(IArchiveManager.class);
            importedImagePath = targetArchiveManager.copyImageBytes(importedArchiveManager, importedImagePath);
            this.addCommand((Command)new EObjectFeatureCommand(null, (EObject)targetObject, (EStructuralFeature)IArchimatePackage.Literals.DIAGRAM_MODEL_IMAGE_PROVIDER__IMAGE_PATH, (Object)importedImagePath));
        }
    }

    private static class AddObjectCommand
    extends Command {
        private IFolder parent;
        private EObject object;
        IFolder oldParent;
        int oldPosition;

        private AddObjectCommand(IFolder parent, IArchimateModelObject object) {
            this.parent = parent;
            this.object = object;
            this.oldParent = (IFolder)object.eContainer();
        }

        public boolean canExecute() {
            return !this.parent.getElements().contains((Object)this.object);
        }

        public void undo() {
            if (this.oldParent != null) {
                this.oldParent.getElements().add(this.oldPosition, (Object)this.object);
            } else {
                if (this.object instanceof IDiagramModel) {
                    EditorManager.closeDiagramEditor((IDiagramModel)((IDiagramModel)this.object));
                }
                this.parent.getElements().remove((Object)this.object);
            }
        }

        public void execute() {
            if (this.oldParent != null) {
                this.oldPosition = this.oldParent.getElements().indexOf((Object)this.object);
            }
            this.parent.getElements().add((Object)this.object);
        }

        public void dispose() {
            this.parent = null;
            this.object = null;
            this.oldParent = null;
        }
    }
}

