/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IIdentifier;
import com.archimatetool.model.IProfile;
import com.archimatetool.modelimporter.IObjectMatcher;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class DefaultObjectMatcher
implements IObjectMatcher {
    private Map<String, EObject> map = new HashMap<String, EObject>();

    public DefaultObjectMatcher(IArchimateModel targetModel) {
        TreeIterator iter = targetModel.eAllContents();
        while (iter.hasNext()) {
            this.add((EObject)iter.next());
        }
    }

    @Override
    public EObject getMatchingObject(EObject eObject) {
        return this.map.get(this.getObjectKey(eObject));
    }

    @Override
    public void add(EObject newObject) {
        String key = this.getObjectKey(newObject);
        if (key != null) {
            this.map.put(key, newObject);
        }
    }

    private String getObjectKey(EObject eObject) {
        if (eObject instanceof IProfile) {
            return ((IProfile)eObject).getConceptType() + ((IProfile)eObject).getName().toLowerCase();
        }
        if (eObject instanceof IIdentifier) {
            return ((IIdentifier)eObject).getId();
        }
        return null;
    }
}

