/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.model.ModelChecker;
import com.archimatetool.editor.ui.components.ExtendedWizardDialog;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.modelimporter.ImportModelWizard;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.StatusDialog;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportModelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IArchimateModel model;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IArchimateModel iArchimateModel = model = part != null ? (IArchimateModel)part.getAdapter(IArchimateModel.class) : null;
        if (model != null) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            try {
                this.doImport(window, model);
            }
            catch (Exception ex) {
                Logger.logError((String)"Error on Export", (Throwable)ex);
                MessageDialog.openError((Shell)window.getShell(), (String)Messages.ImportModelHandler_1, (String)ex.getMessage());
            }
        }
        return null;
    }

    private void doImport(IWorkbenchWindow window, IArchimateModel targetModel) throws Exception {
        ImportModelWizard wizard = new ImportModelWizard();
        ExtendedWizardDialog dialog = new ExtendedWizardDialog(window.getShell(), (IWizard)wizard, "ImportModelWizard"){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button b = this.getButton(16);
                b.setText(Messages.ImportModelHandler_0);
            }
        };
        if (dialog.open() == 0) {
            File importedFile = wizard.getFile();
            if (importedFile == null) {
                return;
            }
            ModelImporter importer = new ModelImporter();
            importer.setUpdate(wizard.shouldUpdate());
            importer.setUpdateAll(wizard.shouldUpdateAll());
            Exception[] exception = new Exception[1];
            BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
                try {
                    importer.doImport(importedFile, targetModel);
                }
                catch (Exception ex) {
                    exceptionArray[0] = ex;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
            ModelChecker checker = new ModelChecker(targetModel);
            if (!checker.checkAll()) {
                checker.showErrorDialog(window.getShell());
            } else if (wizard.shouldShowStatusDialog()) {
                StatusDialog statusDialog = new StatusDialog(window.getShell(), importer.getStatusMessages());
                statusDialog.open();
            }
        }
    }
}

