/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.modelimporter.IPreferenceConstants;
import com.archimatetool.modelimporter.ImporterPlugin;
import com.archimatetool.modelimporter.Messages;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportModelPage
extends WizardPage
implements IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.ImportModel";
    private Text fFileTextField;
    private Button fUpdateButton;
    private Button fUpdateAllButton;
    private Button fShowStatusDialog;

    public ImportModelPage() {
        super("ImportModelPage");
        this.setTitle(Messages.ImportModelPage_0);
        this.setDescription(Messages.ImportModelPage_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/importpref_wiz.png"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Group importGroup = new Group(container, 0);
        importGroup.setText(Messages.ImportModelPage_2);
        importGroup.setLayout((Layout)new GridLayout(3, false));
        importGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)importGroup, 0);
        label.setText(Messages.ImportModelPage_3);
        this.fFileTextField = UIUtils.createSingleTextControl((Composite)importGroup, (int)2048, (boolean)false);
        this.fFileTextField.setLayoutData((Object)new GridData(768));
        String lastFileName = ImporterPlugin.getInstance().getPreferenceStore().getString("ImporterLastFile");
        File lastFile = new File(lastFileName);
        if (lastFile.exists() && lastFile.isFile()) {
            this.fFileTextField.setText(lastFileName);
        }
        this.fFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportModelPage.this.validateFields();
            }
        });
        Button fileButton = new Button((Composite)importGroup, 8);
        fileButton.setText(Messages.ImportModelPage_4);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = ImportModelPage.this.chooseFile();
                if (file != null) {
                    ImportModelPage.this.fFileTextField.setText(file.getPath());
                }
            }
        });
        Group optionsGroup = new Group(container, 0);
        optionsGroup.setText(Messages.ImportModelPage_5);
        optionsGroup.setLayout((Layout)new GridLayout(2, false));
        optionsGroup.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fUpdateButton = new Button((Composite)optionsGroup, 32);
        this.fUpdateButton.setSelection(ImporterPlugin.getInstance().getPreferenceStore().getBoolean("ImporterUpdate"));
        this.fUpdateButton.setText(Messages.ImportModelPage_6);
        this.fUpdateButton.setLayoutData((Object)gd);
        this.fUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportModelPage.this.setButtonState();
            }
        });
        this.fUpdateAllButton = new Button((Composite)optionsGroup, 32);
        this.fUpdateAllButton.setSelection(ImporterPlugin.getInstance().getPreferenceStore().getBoolean("ImporterUpdateAll"));
        this.fUpdateAllButton.setText(Messages.ImportModelPage_8);
        this.fUpdateAllButton.setLayoutData((Object)gd);
        this.fShowStatusDialog = new Button((Composite)optionsGroup, 32);
        this.fShowStatusDialog.setSelection(ImporterPlugin.getInstance().getPreferenceStore().getBoolean("ImporterShowStatusDialog"));
        this.fShowStatusDialog.setText(Messages.ImportModelPage_9);
        this.fShowStatusDialog.setLayoutData((Object)gd);
        this.setButtonState();
    }

    String getFileName() {
        return this.fFileTextField.getText();
    }

    boolean shouldUpdate() {
        return this.fUpdateButton.getSelection();
    }

    boolean shouldUpdateAll() {
        return this.fUpdateAllButton.getSelection();
    }

    boolean shouldShowStatusDialog() {
        return this.fShowStatusDialog.getSelection();
    }

    private void setButtonState() {
        this.fUpdateAllButton.setEnabled(this.fUpdateButton.getSelection());
        if (!this.fUpdateButton.getSelection()) {
            this.fUpdateAllButton.setSelection(false);
        }
    }

    private void validateFields() {
        String fileName = this.getFileName();
        if (!StringUtils.isSetAfterTrim((String)fileName)) {
            this.setErrorMessage(Messages.ImportModelPage_7);
            return;
        }
        this.setErrorMessage(null);
    }

    private File chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.archimate", "*.*"});
        dialog.setFileName(this.getFileName());
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    void storePreferences() {
        IPreferenceStore store = ImporterPlugin.getInstance().getPreferenceStore();
        store.setValue("ImporterLastFile", this.getFileName());
        store.setValue("ImporterUpdate", this.shouldUpdate());
        store.setValue("ImporterUpdateAll", this.shouldUpdateAll());
        store.setValue("ImporterShowStatusDialog", this.shouldShowStatusDialog());
    }
}

