/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.export.svg;

import com.archimatetool.editor.diagram.IImageExportProvider;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.export.svg.ExtendedGraphicsToGraphics2DAdaptor;
import com.archimatetool.export.svg.Messages;
import com.archimatetool.export.svg.graphiti.GraphicsToGraphics2DAdaptor;
import com.archimatetool.model.IDiagramModel;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.Map;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractExportProvider
implements IImageExportProvider {
    private IFigure figure;
    protected SVGGraphics2D svgGraphics2D;
    protected Rectangle viewPortBounds;
    protected boolean textAsShapes = true;
    protected boolean embedFonts = false;
    protected boolean textOffsetWorkaround = false;
    protected Map<String, String> attributes;
    private static boolean awtFontsLoaded;

    public void setDrawTextAsShapes(boolean set) {
        this.textAsShapes = set;
    }

    public boolean getDrawTextAsShapes() {
        return this.textAsShapes;
    }

    public void setEmbedFonts(boolean set) {
        this.embedFonts = set;
    }

    public boolean getEmbedFonts() {
        return this.embedFonts;
    }

    public void setTextOffsetWorkaround(boolean set) {
        this.textOffsetWorkaround = set;
    }

    public boolean getTextOffsetWorkaround() {
        return this.textOffsetWorkaround;
    }

    public void setElementRootAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    protected void initialiseGraphics() {
        AbstractExportProvider.loadUserFontsIntoAWT();
        Document document = this.createDocument();
        SVGGeneratorContext ctx = this.createContext(document, this.getEmbedFonts());
        this.svgGraphics2D = this.getSVGGraphics2D(ctx);
        GraphicsToGraphics2DAdaptor graphicsAdaptor = this.createGraphicsToGraphics2DAdaptor((Graphics2D)this.svgGraphics2D, this.viewPortBounds);
        graphicsAdaptor.useTextOffsetWorkaround = this.getTextOffsetWorkaround();
        this.figure.paint((Graphics)graphicsAdaptor);
        graphicsAdaptor.dispose();
    }

    protected void setFigure(IFigure figure) {
        this.figure = figure;
        this.viewPortBounds = this.getViewportBounds(figure);
    }

    protected SVGGraphics2D getSVGGraphics2D(SVGGeneratorContext ctx) {
        return new SVGGraphics2D(ctx, this.getDrawTextAsShapes());
    }

    protected Rectangle getViewportBounds(IFigure figure) {
        Rectangle rect = DiagramUtils.getMinimumBounds((IFigure)figure);
        if (rect == null) {
            rect = new Rectangle(0, 0, 100, 100);
        } else {
            rect.expand(10, 10);
        }
        return rect;
    }

    protected Document createDocument() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        return domImpl.createDocument(svgNS, "svg", null);
    }

    protected SVGGeneratorContext createContext(Document document, boolean embedFonts) {
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setEmbeddedFontsOn(embedFonts);
        ctx.setComment(Messages.SVGExportProvider_1);
        return ctx;
    }

    protected GraphicsToGraphics2DAdaptor createGraphicsToGraphics2DAdaptor(Graphics2D graphics2d, Rectangle viewPort) {
        ExtendedGraphicsToGraphics2DAdaptor graphicsAdaptor = new ExtendedGraphicsToGraphics2DAdaptor(graphics2d, viewPort);
        graphicsAdaptor.translate(viewPort.x * -1, viewPort.y * -1);
        graphicsAdaptor.setClip(viewPort);
        graphicsAdaptor.setAdvanced(true);
        return graphicsAdaptor;
    }

    protected void setViewBoxAttribute(Element root, int min_x, int min_y, int width, int height) {
        root.setAttributeNS(null, "viewBox", min_x + " " + min_y + " " + width + " " + height);
    }

    protected Element createElementForView(IDiagramModel diagramModel, boolean setViewBox) {
        Shell shell = new Shell();
        try {
            GraphicalViewerImpl viewer = DiagramUtils.createViewer((IDiagramModel)diagramModel, (Composite)shell);
            LayerManager layerManager = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
            IFigure figure = layerManager.getLayer((Object)"Printable Layers");
            this.setFigure(figure);
            this.initialiseGraphics();
        }
        finally {
            shell.dispose();
        }
        Element root = this.svgGraphics2D.getRoot();
        if (setViewBox) {
            this.setViewBoxAttribute(root, 0, 0, this.viewPortBounds.width, this.viewPortBounds.height);
        }
        if (this.attributes != null) {
            for (Map.Entry<String, String> att : this.attributes.entrySet()) {
                root.setAttributeNS(null, att.getKey(), att.getValue());
            }
        }
        return root;
    }

    private static void loadUserFontsIntoAWT() {
        File fontsFolder;
        if (PlatformUtils.isWindows() && !awtFontsLoaded && (fontsFolder = new File(System.getProperty("user.home"), "AppData/Local/Microsoft/Windows/Fonts")).exists()) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            File[] fileArray = fontsFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    try {
                        Font font = Font.createFont(0, file);
                        ge.registerFont(font);
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            awtFontsLoaded = true;
        }
    }
}

