/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.export.svg;

import com.archimatetool.editor.diagram.IImageExportProvider;
import com.archimatetool.export.svg.AbstractExportProvider;
import com.archimatetool.export.svg.ExportSVGPlugin;
import com.archimatetool.export.svg.IPreferenceConstants;
import com.archimatetool.export.svg.Messages;
import com.archimatetool.model.IDiagramModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.w3c.dom.Element;

public class SVGExportProvider
extends AbstractExportProvider
implements IPreferenceConstants {
    public static final String SVG_IMAGE_EXPORT_PROVIDER = "com.archimatetool.export.svg.imageExporter";
    Button fSetViewboxButton;
    Spinner fSpinner1;
    Spinner fSpinner2;
    Spinner fSpinner3;
    Spinner fSpinner4;
    Button fTextAsShapesButton;
    Button fEmbedFontsButton;
    Button fTextOffsetWorkaroundButton;

    public void export(String providerID, File file) throws Exception {
        this.setDrawTextAsShapes(this.fTextAsShapesButton.getSelection());
        this.setEmbedFonts(this.fEmbedFontsButton.getSelection());
        this.setTextOffsetWorkaround(this.fTextOffsetWorkaroundButton.getSelection());
        this.initialiseGraphics();
        Element root = this.svgGraphics2D.getRoot();
        if (this.fSetViewboxButton.getSelection()) {
            this.setViewBoxAttribute(root, this.fSpinner1.getSelection(), this.fSpinner2.getSelection(), this.fSpinner3.getSelection(), this.fSpinner4.getSelection());
        }
        this.writeElementToFile(root, file);
        this.savePreferences();
    }

    public void export(IDiagramModel diagramModel, File file, boolean setViewBox) throws Exception {
        Element root = this.createElementForView(diagramModel, setViewBox);
        this.writeElementToFile(root, file);
    }

    public String getSVGString(IDiagramModel diagramModel, boolean setViewBox) throws Exception {
        Element root = this.createElementForView(diagramModel, setViewBox);
        try {
            String string;
            block13: {
                Throwable throwable = null;
                Object var5_6 = null;
                StringWriter out = new StringWriter();
                try {
                    this.svgGraphics2D.stream(root, (Writer)out);
                    string = out.toString();
                    if (out == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                out.close();
            }
            return string;
        }
        finally {
            this.svgGraphics2D.dispose();
        }
    }

    private void writeElementToFile(Element root, File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                this.svgGraphics2D.stream(root, (Writer)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.svgGraphics2D.dispose();
        }
    }

    public void init(IImageExportProvider.IExportDialogAdapter adapter, Composite container, IFigure figure) {
        this.setFigure(figure);
        container.setLayout((Layout)new GridLayout(8, false));
        GridDataFactory.create((int)768).applyTo((Control)container);
        this.fSetViewboxButton = new Button(container, 32);
        this.fSetViewboxButton.setText(Messages.SVGExportProvider_0);
        GridDataFactory.create((int)768).span(8, 1).applyTo((Control)this.fSetViewboxButton);
        this.fSetViewboxButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateControls()));
        int min = -100000;
        int max = 100000;
        Label label = new Label(container, 0);
        label.setText(" " + Messages.SVGExportProvider_2);
        this.fSpinner1 = new Spinner(container, 2048);
        this.fSpinner1.setMinimum(min);
        this.fSpinner1.setMaximum(max);
        label = new Label(container, 0);
        label.setText(" " + Messages.SVGExportProvider_3);
        this.fSpinner2 = new Spinner(container, 2048);
        this.fSpinner2.setMinimum(min);
        this.fSpinner2.setMaximum(max);
        label = new Label(container, 0);
        label.setText(" " + Messages.SVGExportProvider_4);
        this.fSpinner3 = new Spinner(container, 2048);
        this.fSpinner3.setMaximum(max);
        label = new Label(container, 0);
        label.setText(" " + Messages.SVGExportProvider_5);
        this.fSpinner4 = new Spinner(container, 2048);
        this.fSpinner4.setMaximum(max);
        this.fTextAsShapesButton = new Button(container, 32);
        this.fTextAsShapesButton.setText(Messages.SVGExportProvider_6);
        GridDataFactory.create((int)768).span(8, 1).applyTo((Control)this.fTextAsShapesButton);
        this.fEmbedFontsButton = new Button(container, 32);
        this.fEmbedFontsButton.setText(Messages.SVGExportProvider_7);
        GridDataFactory.create((int)768).span(8, 1).applyTo((Control)this.fEmbedFontsButton);
        this.fTextOffsetWorkaroundButton = new Button(container, 32);
        this.fTextOffsetWorkaroundButton.setText(Messages.SVGExportProvider_8);
        GridDataFactory.create((int)768).span(8, 1).applyTo((Control)this.fTextOffsetWorkaroundButton);
        this.loadPreferences();
        this.fSpinner3.setSelection(this.viewPortBounds.width);
        this.fSpinner4.setSelection(this.viewPortBounds.height);
    }

    private void updateControls() {
        this.fSpinner1.setEnabled(this.fSetViewboxButton.getSelection());
        this.fSpinner2.setEnabled(this.fSetViewboxButton.getSelection());
        this.fSpinner3.setEnabled(this.fSetViewboxButton.getSelection());
        this.fSpinner4.setEnabled(this.fSetViewboxButton.getSelection());
    }

    protected void loadPreferences() {
        String[] parts;
        IPreferenceStore store = ExportSVGPlugin.getInstance().getPreferenceStore();
        this.fSetViewboxButton.setSelection(store.getBoolean("viewBoxEnabled"));
        this.updateControls();
        int min_x = 0;
        int min_y = 0;
        String s = store.getString("viewBox");
        if (s != null && (parts = s.split(" ")).length >= 2) {
            try {
                min_x = Integer.valueOf(parts[0]);
                min_y = Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        this.fSpinner1.setSelection(min_x);
        this.fSpinner2.setSelection(min_y);
        this.fTextAsShapesButton.setSelection(store.getBoolean("svgTextAsShapes"));
        this.fEmbedFontsButton.setSelection(store.getBoolean("svgEmbedFonts"));
        this.fTextOffsetWorkaroundButton.setSelection(store.getBoolean("svgTextOffset"));
    }

    protected void savePreferences() {
        IPreferenceStore store = ExportSVGPlugin.getInstance().getPreferenceStore();
        store.setValue("viewBoxEnabled", this.fSetViewboxButton.getSelection());
        int min_x = this.fSpinner1.getSelection();
        int min_y = this.fSpinner2.getSelection();
        String s = min_x + " " + min_y;
        store.setValue("viewBox", s);
        store.setValue("svgTextAsShapes", this.fTextAsShapesButton.getSelection());
        store.setValue("svgEmbedFonts", this.fEmbedFontsButton.getSelection());
        store.setValue("svgTextOffset", this.fTextOffsetWorkaroundButton.getSelection());
    }
}

