/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas;

import com.archimatetool.canvas.CanvasEditorPlugin;
import com.archimatetool.canvas.ICanvasImages;
import com.archimatetool.canvas.Messages;
import com.archimatetool.canvas.templates.wizard.NewCanvasFromTemplateWizard;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.components.ExtendedWizardDialog;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.services.UIRequest;
import com.archimatetool.editor.ui.services.UIRequestManager;
import com.archimatetool.editor.views.tree.TreeEditElementRequest;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.util.UUIDFactory;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class NewModelWithCanvasExtensionContributionFactory
extends ExtensionContributionFactory {
    private static final boolean ENABLED = true;
    private Expression visibleExpression = new Expression(){

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            boolean isVisible = CanvasEditorPlugin.getInstance().getPreferenceStore().getBoolean("canvasEditorEnabled");
            return isVisible ? EvaluationResult.TRUE : EvaluationResult.FALSE;
        }
    };

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        ActionContributionItem item = new ActionContributionItem((IAction)new NewModelWithCanvasAction());
        additions.addContributionItem((IContributionItem)item, this.visibleExpression);
    }

    private class NewModelWithCanvasAction
    extends Action {
        private NewModelWithCanvasAction() {
        }

        public String getText() {
            return Messages.NewModelWithCanvasExtensionContributionFactory_0;
        }

        public void run() {
            NewCanvasFromTemplateWizard wizard = new NewCanvasFromTemplateWizard();
            ExtendedWizardDialog dialog = new ExtendedWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard, "NewCanvasFromTemplateWizard");
            if (dialog.open() == 0) {
                try {
                    File file = wizard.getTempModelFile();
                    if (file != null) {
                        IArchimateModel model = IEditorModelManager.INSTANCE.openModel(file);
                        if (model != null) {
                            model.setName(Messages.NewModelWithCanvasExtensionContributionFactory_1);
                            model.setVersion("5.0.0");
                            model.setFile(null);
                            UUIDFactory.generateNewIDs((EObject)model);
                            EditorManager.openDiagramEditor((IDiagramModel)model.getDefaultDiagramModel(), (boolean)false);
                            UIRequestManager.INSTANCE.fireRequestAsync((UIRequest)new TreeEditElementRequest((Object)this, (Object)model));
                        }
                        file.delete();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.NewModelWithCanvasExtensionContributionFactory_2, (String)ex.getMessage());
                }
            }
        }

        public String getId() {
            return "newModelWithCanvasAction";
        }

        public ImageDescriptor getImageDescriptor() {
            return ICanvasImages.ImageFactory.getImageDescriptor("img/newfile_wiz.png");
        }
    }
}

