/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas;

import com.archimatetool.canvas.CanvasEditorPlugin;
import com.archimatetool.canvas.ICanvasImages;
import com.archimatetool.canvas.Messages;
import com.archimatetool.canvas.model.ICanvasModel;
import com.archimatetool.canvas.templates.wizard.SaveCanvasAsTemplateWizard;
import com.archimatetool.editor.ui.components.ExtendedWizardDialog;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class SaveAsCanvasExtensionContributionFactory
extends ExtensionContributionFactory {
    private ICanvasModel fCurrentCanvasModel;
    private Expression canvasExpression = new Expression(){

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            SaveAsCanvasExtensionContributionFactory.this.fCurrentCanvasModel = null;
            Object o = context.getDefaultVariable();
            if (o instanceof List && ((List)o).size() > 0 && (o = ((List)o).get(0)) instanceof ICanvasModel) {
                SaveAsCanvasExtensionContributionFactory.this.fCurrentCanvasModel = (ICanvasModel)o;
            }
            return SaveAsCanvasExtensionContributionFactory.this.fCurrentCanvasModel != null ? EvaluationResult.TRUE : EvaluationResult.FALSE;
        }
    };

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        boolean enabled = CanvasEditorPlugin.getInstance().getPreferenceStore().getBoolean("canvasEditorEnabled");
        if (!enabled) {
            return;
        }
        ActionContributionItem item = new ActionContributionItem((IAction)new SaveCanvasAsTemplateAction());
        additions.addContributionItem((IContributionItem)item, this.canvasExpression);
    }

    private class SaveCanvasAsTemplateAction
    extends Action {
        private SaveCanvasAsTemplateAction() {
        }

        public String getText() {
            return Messages.SaveAsCanvasExtensionContributionFactory_0;
        }

        public void run() {
            if (SaveAsCanvasExtensionContributionFactory.this.fCurrentCanvasModel != null) {
                ExtendedWizardDialog dialog = new ExtendedWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new SaveCanvasAsTemplateWizard(SaveAsCanvasExtensionContributionFactory.this.fCurrentCanvasModel), "SaveCanvasAsTemplateWizard");
                dialog.open();
            } else {
                System.err.println("Canvas was null in " + String.valueOf(((Object)((Object)this)).getClass()));
            }
        }

        public String getId() {
            return "saveCanvasAsTemplateAction";
        }

        public ImageDescriptor getImageDescriptor() {
            return ICanvasImages.ImageFactory.getImageDescriptor("img/canvas.png");
        }
    }
}

