/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.figures;

import com.archimatetool.canvas.model.ICanvasModelBlock;
import com.archimatetool.editor.diagram.figures.AbstractContainerFigure;
import com.archimatetool.editor.diagram.figures.ITextFigure;
import com.archimatetool.editor.diagram.figures.IconicDelegate;
import com.archimatetool.editor.diagram.figures.TextPositionDelegate;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;

public class CanvasBlockFigure
extends AbstractContainerFigure
implements ITextFigure {
    private TextFlow fTextFlow;
    private TextPositionDelegate fTextPositionDelegate;
    private Color fBorderColor;
    private static final int MAX_ICON_SIZE = 100;

    public CanvasBlockFigure(ICanvasModelBlock diagramModelBlock) {
        super((IDiagramModelObject)diagramModelBlock);
    }

    public ICanvasModelBlock getDiagramModelObject() {
        return (ICanvasModelBlock)super.getDiagramModelObject();
    }

    protected void setUI() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        Locator mainLocator = new Locator(){

            public void relocate(IFigure target) {
                Rectangle bounds = CanvasBlockFigure.this.getBounds().getCopy();
                CanvasBlockFigure.this.translateFromParent((Translatable)bounds);
                target.setBounds(bounds);
            }
        };
        FlowPage flowPage = new FlowPage();
        this.fTextFlow = new TextFlow();
        this.fTextFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.fTextFlow, 0));
        flowPage.add((IFigure)this.fTextFlow);
        Figure textWrapperFigure = new Figure();
        textWrapperFigure.setLayoutManager((LayoutManager)new GridLayout());
        textWrapperFigure.add((IFigure)flowPage, (Object)new GridData(0x1000000, 0x1000000, true, true));
        this.add((IFigure)textWrapperFigure, mainLocator);
        this.fTextPositionDelegate = new TextPositionDelegate((IFigure)textWrapperFigure, (IFigure)flowPage, (ITextPosition)this.getDiagramModelObject());
        this.add(this.getMainFigure(), mainLocator);
        this.setIconicDelegate(new IconicDelegate((IIconic)this.getDiagramModelObject(), 100));
    }

    public void refreshVisuals() {
        this.setText();
        this.setFont();
        this.setFillColor();
        this.setFontColor();
        this.setBorderColor();
        ((FlowPage)this.fTextFlow.getParent()).setHorizontalAligment(this.getDiagramModelObject().getTextAlignment());
        this.fTextPositionDelegate.updateTextPosition();
        this.updateIconImage();
        this.repaint();
    }

    public void setText() {
        String content = this.getDiagramModelObject().getContent();
        this.getTextControl().setText(StringUtils.safeString((String)content));
    }

    protected void setBorderColor() {
        String val = this.getDiagramModelObject().getBorderColor();
        Color c = ColorFactory.get((String)val);
        if (c != this.fBorderColor) {
            this.fBorderColor = c;
            this.repaint();
        }
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    public TextFlow getTextControl() {
        return this.fTextFlow;
    }

    protected void drawFigure(Graphics graphics) {
        this.drawFigure(graphics, this.getFillColor());
    }

    protected void drawTargetFeedback(Graphics graphics) {
        this.drawFigure(graphics, ColorFactory.getDarkerColor((Color)this.getFillColor()));
    }

    private void drawFigure(Graphics graphics, Color background) {
        boolean drawBorder;
        graphics.pushState();
        graphics.setAntialias(1);
        graphics.setAlpha(this.getAlpha());
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        boolean bl = drawBorder = this.getBorderColor() != null && this.getLineStyle() != 3;
        if (drawBorder) {
            this.setLineWidth(graphics, bounds);
            this.setLineStyle(graphics);
        }
        graphics.setBackgroundColor(background);
        graphics.fillRectangle(bounds);
        this.drawIconImage(graphics, bounds);
        if (drawBorder) {
            graphics.setAlpha(this.getLineAlpha());
            graphics.setForegroundColor(this.getBorderColor());
            graphics.drawRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        graphics.popState();
    }
}

