/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.figures;

import com.archimatetool.canvas.figures.Messages;
import com.archimatetool.canvas.figures.MultiToolTipFigure;
import com.archimatetool.canvas.model.ICanvasModelSticky;
import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.diagram.figures.ITextFigure;
import com.archimatetool.editor.diagram.figures.IconicDelegate;
import com.archimatetool.editor.diagram.figures.TextPositionDelegate;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Path;

public class CanvasStickyFigure
extends AbstractDiagramModelObjectFigure
implements ITextFigure {
    private TextFlow fTextFlow;
    private TextPositionDelegate fTextPositionDelegate;
    private MultiToolTipFigure fTooltip;
    private Color fBorderColor;
    private static final int MAX_ICON_SIZE = 100;

    public CanvasStickyFigure(ICanvasModelSticky diagramModelSticky) {
        super((IDiagramModelObject)diagramModelSticky);
    }

    public ICanvasModelSticky getDiagramModelObject() {
        return (ICanvasModelSticky)super.getDiagramModelObject();
    }

    protected void setUI() {
        this.setLayoutManager((LayoutManager)new GridLayout());
        FlowPage flowPage = new FlowPage();
        this.fTextFlow = new TextFlow();
        this.fTextFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.fTextFlow, 0));
        flowPage.add((IFigure)this.fTextFlow);
        this.add((IFigure)flowPage, new GridData(0x1000000, 0x1000000, true, true));
        this.fTextPositionDelegate = new TextPositionDelegate((IFigure)this, (IFigure)flowPage, (ITextPosition)this.getDiagramModelObject());
        this.setIconicDelegate(new IconicDelegate((IIconic)this.getDiagramModelObject(), 100));
    }

    public void refreshVisuals() {
        this.setText();
        this.setFont();
        this.setFillColor();
        this.setFontColor();
        this.setBorderColor();
        ((FlowPage)this.fTextFlow.getParent()).setHorizontalAligment(this.getDiagramModelObject().getTextAlignment());
        this.fTextPositionDelegate.updateTextPosition();
        this.updateIconImage();
        this.repaint();
    }

    public void setText() {
        String text = this.getDiagramModelObject().getContent();
        this.getTextControl().setText(StringUtils.safeString((String)text));
    }

    public TextFlow getTextControl() {
        return this.fTextFlow;
    }

    protected void setBorderColor() {
        String val = this.getDiagramModelObject().getBorderColor();
        Color c = ColorFactory.get((String)val);
        if (c != this.fBorderColor) {
            this.fBorderColor = c;
            this.repaint();
        }
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    protected void paintFigure(Graphics graphics) {
        graphics.pushState();
        graphics.setAntialias(1);
        graphics.setAlpha(this.getAlpha());
        Rectangle bounds = this.getBounds().getCopy();
        --bounds.width;
        --bounds.height;
        this.setLineWidth(graphics, bounds);
        if (PlatformUtils.isLinux() && ImageFactory.getDeviceZoom() > 100) {
            graphics.setBackgroundColor(this.getFillColor());
            graphics.fillRectangle(bounds);
        } else {
            graphics.setForegroundColor(this.getFillColor());
            graphics.setBackgroundColor(ColorFactory.getLighterColor((Color)this.getFillColor(), (float)0.9f));
            graphics.fillGradient(bounds, false);
        }
        this.drawIconImage(graphics, bounds);
        if (this.getBorderColor() != null) {
            graphics.setAlpha(this.getLineAlpha());
            float lineOffset = (float)this.getLineWidth() / 2.0f;
            graphics.setForegroundColor(ColorFactory.getLighterColor((Color)this.getBorderColor(), (float)0.82f));
            Path path = new Path(null);
            path.moveTo((float)bounds.x - lineOffset, (float)bounds.y);
            path.lineTo((float)(bounds.x + bounds.width), (float)bounds.y);
            path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height));
            graphics.drawPath(path);
            path.dispose();
            graphics.setForegroundColor(this.getBorderColor());
            path = new Path(null);
            path.moveTo((float)bounds.x, (float)bounds.y - lineOffset);
            path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
            path.lineTo((float)(bounds.x + bounds.width) + lineOffset, (float)(bounds.y + bounds.height));
            graphics.drawPath(path);
            path.dispose();
        }
        graphics.popState();
    }

    public IFigure getToolTip() {
        String notes;
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewTooltips")) {
            return null;
        }
        if (this.fTooltip == null) {
            this.fTooltip = new MultiToolTipFigure();
            this.setToolTip((IFigure)this.fTooltip);
        }
        if (StringUtils.isSet((String)(notes = this.getDiagramModelObject().getNotes()))) {
            this.fTooltip.setText(notes);
        } else {
            this.fTooltip.setText(Messages.CanvasStickyFigure_0);
        }
        return this.fTooltip;
    }
}

