/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.commandline.providers;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.commandline.providers.Messages;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.utils.ZipUtils;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.util.UUIDFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.osgi.util.NLS;

public class CreateEmptyModelProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.CreateEmptyModelProvider_0;
    static final String OPTION_CREATE_EMPTY_MODEL = "createEmptyModel";

    @Override
    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_CREATE_EMPTY_MODEL).hasArg().optionalArg(true).argName(Messages.CreateEmptyModelProvider_1).desc(Messages.CreateEmptyModelProvider_2).build();
        options.addOption(option);
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption(OPTION_CREATE_EMPTY_MODEL)) {
            IArchimateModel model = null;
            String template = commandLine.getOptionValue(OPTION_CREATE_EMPTY_MODEL);
            model = template != null ? this.createEmptyModelFromTemplate(template) : this.createEmptyModel();
            CommandLineState.setModel(model);
        }
    }

    private IArchimateModel createEmptyModelFromTemplate(String template) throws IOException {
        File fileTemplate = new File(template);
        if (!fileTemplate.exists()) {
            throw new IOException(NLS.bind((String)Messages.CreateEmptyModelProvider_3, (Object)template));
        }
        File tmp = File.createTempFile("~architemplate", null);
        tmp.deleteOnExit();
        File file = ZipUtils.extractZipEntry((File)fileTemplate, (String)"model.archimate", (File)tmp);
        IArchimateModel model = IEditorModelManager.INSTANCE.load(file);
        if (model == null) {
            this.logError(Messages.CreateEmptyModelProvider_4);
            return null;
        }
        model.setName(Messages.CreateEmptyModelProvider_5 + " " + model.getName());
        model.setVersion("5.0.0");
        model.setFile(null);
        UUIDFactory.generateNewIDs((EObject)model);
        this.logMessage(NLS.bind((String)Messages.CreateEmptyModelProvider_6, (Object)fileTemplate));
        return model;
    }

    private IArchimateModel createEmptyModel() {
        IArchimateModel model = IArchimateFactory.eINSTANCE.createArchimateModel();
        model.setDefaults();
        IArchiveManager archiveManager = IArchiveManager.FACTORY.createArchiveManager((IArchimateModel)model);
        model.setAdapter(IArchiveManager.class, (Object)archiveManager);
        CommandStack cmdStack = new CommandStack();
        model.setAdapter(CommandStack.class, (Object)cmdStack);
        this.logMessage(Messages.CreateEmptyModelProvider_7);
        return model;
    }

    @Override
    public int getPriority() {
        return 8;
    }

    @Override
    protected String getLogPrefix() {
        return PREFIX;
    }
}

