/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.commandline.providers;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.commandline.providers.Messages;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.osgi.util.NLS;

public class LoadModelFromFileProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.LoadModelFromFileProvider_0;
    static final String OPTION_LOAD_FILE_MODEL = "loadModel";

    @Override
    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_LOAD_FILE_MODEL).hasArg().argName(Messages.LoadModelFromFileProvider_1).desc(Messages.LoadModelFromFileProvider_2).build();
        options.addOption(option);
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption(OPTION_LOAD_FILE_MODEL)) {
            String filePath = commandLine.getOptionValue(OPTION_LOAD_FILE_MODEL);
            File file = new File(filePath);
            IArchimateModel model = IEditorModelManager.INSTANCE.load(file);
            if (model == null) {
                throw new IOException(NLS.bind((String)Messages.LoadModelFromFileProvider_3, (Object)filePath));
            }
            CommandLineState.setModel(model);
            this.logMessage(NLS.bind((String)Messages.LoadModelFromFileProvider_4, (Object)model.getName()));
        }
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    protected String getLogPrefix() {
        return PREFIX;
    }
}

