Attribute VB_Name = "ExcelVBA"
Option Explicit

'
' Here begins the demo program
Sub initTable()
Cells(2, 4) = "Serial port:"
Cells(2, 5) = "COM1"
Cells(3, 4) = "Baudrate:"
Cells(3, 5) = "38400"
Cells(4, 4) = "Parity:"
Cells(4, 5) = "O"
Cells(6, 4) = "MPI/PPI Address:"
Cells(6, 5) = 2
Cells(7, 4) = "IP Address:"
Cells(7, 5) = "192.168.1.1"
Cells(8, 4) = "Access point:"
Cells(8, 5) = "/S7ONLINE"
End Sub


'
' This initialization is used in all test programs. In a real program, where you would
' want to read again and again, keep the dc and di until your program terminates.
'
Private Function initialize(ByRef ph As Long, ByRef di As Long, ByRef dc As Long)
ph = 0
di = 0
dc = 0
Rem uncomment the daveSetDebug... line, save your sheet
Rem run excel from dos box with: excel yoursheet >debugout.txt
Rem send me the file debugout.txt if you have trouble.
Rem call daveSetDebug(daveDebugAll)
initialize = -1
baud$ = Cells(3, 5)
If (baud$ = "") Then Call initTable
Cells(12, 2) = "Running"
res = -1
port = Cells(2, 5)
baud$ = Cells(3, 5)
parity$ = Cells(4, 5)
peer$ = Cells(7, 5)
acspnt$ = Cells(8, 5)
ph = setPort(port, baud$, Asc(Left$(parity$, 1)))
' Alternatives:
Rem ph = openSocket(102, peer$)    ' for ISO over TCP
Rem ph = openSocket(1099, peer$)' for IBH NetLink
Rem ph = openS7online(acspnt$) ' to use Siemes libraries for transport (s7online)
Cells(2, 1) = "port handle:"
Cells(2, 2) = ph
If (ph > 0) Then
    di = daveNewInterface(ph, ph, "IF1", 0, daveProtoMPI, daveSpeed187k)
' Alternatives:
'di = daveNewInterface(ph, ph, "IF1", 0, daveProtoPPI, daveSpeed187k)
'di = daveNewInterface(ph, ph, "IF1", 0, daveProtoMPI_IBH, daveSpeed187k)
'di = daveNewInterface(ph, ph, "IF1", 0, daveProtoISOTCP, daveSpeed187k)
'di = daveNewInterface(ph, ph, "IF1", 0, daveProtoS7online, daveSpeed187k)
'
'You can set longer timeout here, if you have  a slow connection
'    Call daveSetTimeout(di, 500000)
    res = daveInitAdapter(di)
    Cells(3, 1) = "result from initAdapter:"
    Cells(3, 2) = res
    If res = 0 Then
        MpiPpi = Cells(6, 5)
'
' with ISO over TCP, set correct values for rack and slot of the CPU
'
        dc = daveNewConnection(di, MpiPpi, Rack, Slot)
        res = daveConnectPLC(dc)
        Cells(4, 1) = "result from connectPLC:"
        Cells(4, 2) = res
        If res = 0 Then
            initialize = 0
        End If
    End If
End If
End Function
'
' Disconnect from PLC, disconnect from Adapter, close the serial interface or TCP/IP socket
'
Private Sub cleanUp(ByRef ph As Long, ByRef di As Long, ByRef dc As Long)
If dc <> 0 Then
    res = daveDisconnectPLC(dc)
    Call daveFree(dc)
    dc = 0
End If
If di <> 0 Then
    res = daveDisconnectAdapter(di)
    Call daveFree(di)
    di = 0
End If
If ph <> 0 Then
    res = closePort(ph)
    ph = 0
End If
Cells(12, 2) = "Finished"
End Sub
'
' read some values from FD0,FD4,FD8,FD12 (MD0,MD4,MD8,MD12 in german notation)
'  to read from data block 12, you would need to write:
'  daveReadBytes(dc, daveDB, 12, 0, 16, 0)
'
Sub readFromPLC()
Cells(1, 2) = "Testing PLC read"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
    res2 = daveReadBytes(dc, daveFlags, 0, 0, 16, 0)
    Cells(5, 1) = "result from readBytes:"
    Cells(5, 2) = res2
    If res2 = 0 Then
        v1 = daveGetS32(dc)
        Cells(7, 1) = "MD0(DINT):"
        Cells(7, 2) = v1
        v2 = daveGetS32(dc)
        Cells(8, 1) = "MD4(DINT):"
        Cells(8, 2) = v2
        v3 = daveGetS32(dc)
        Cells(9, 1) = "MD8(DINT):"
        Cells(9, 2) = v3
        v4 = daveGetFloat(dc)
        Cells(10, 1) = "MD12(REAL):"
        Cells(10, 2) = v4
        v5 = daveGetFloatAt(dc, 12)
    Else
        e$ = daveStrError(res)
        Cells(9, 4) = "error:"
        Cells(9, 5) = e$
    End If
End If
Call cleanUp(ph, di, dc)
End Sub

Sub startPLC()
Cells(1, 2) = "Testing Start PLC"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
    res2 = daveStart(dc)
    Cells(14, 2) = res2
Else
    e$ = daveStrError(res)
    Cells(9, 5) = e$
End If
Call cleanUp(ph, di, dc)
End Sub
Sub stopPLC()
Cells(1, 2) = "Testing Start PLC"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
    res2 = daveStop(dc)
    Cells(14, 1) = "result:"
    Cells(14, 2) = res2
Else
    e$ = daveStrError(res)
    Cells(9, 4) = "error:"
    Cells(9, 5) = e$
End If
Call cleanUp(ph, di, dc)
End Sub

Sub readOrderCode()
Cells(1, 2) = "Testing read Order code"
Dim ph As Long, di As Long, dc As Long
Dim buffer(50) As Byte
res = initialize(ph, di, dc)
If res = 0 Then
    res2 = daveGetOrderCode(dc, buffer(0))
    Cells(14, 2) = res2
    If res2 = 0 Then
        For i = 0 To daveOrderCodeSize - 2 'last character is chr$(0), don't copy it
            oc$ = oc$ + Chr$(buffer(i))
        Next i
        Cells(14, 3) = oc$
    Else
        e$ = daveStrError(res)
        Cells(9, 4) = "error:"
        Cells(9, 5) = e$
    End If
End If
Call cleanUp(ph, di, dc)
End Sub

Sub readDiagnostic()
' The internal buffer is not big enough for all SZL lists.
' You must provide a buffer of sufficient size.
Dim buffer(4096) As Byte
Cells(1, 2) = "Testing read CPU Diagnostic List SZL (A0,0)"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
    ID = &HA0
    res2 = daveReadSZL(dc, ID, 0, buffer(0))
    If res2 = 0 Then
        al = daveGetAnswLen(dc)
        If (al >= 4) Then
            ID = daveGetU16from(buffer(0))
            index = daveGetU16from(buffer(2))
            If (al >= 8) Then
                Cells(1, 15) = "Diagnostic List from CPU"
                ItemLen = daveGetU16from(buffer(4))
                ItemCount = daveGetU16from(buffer(6))
                bpos = 8    ' remember buffer position
                For i = 0 To ItemCount - 1
                    dia$ = ""
                    For j = 0 To ItemLen - 1
                        dia$ = dia$ + Hex$(buffer(bpos)) + ","
                        bpos = bpos + 1
                    Next j
                    Cells(i + 3, 15) = dia$
                Next i
            End If
        End If
    Else
        e$ = daveStrError(res2)
        Cells(9, 4) = "error:"
        Cells(9, 5) = e$
    End If
End If
Call cleanUp(ph, di, dc)
End Sub



Sub bufferTest()
Dim buffer(1024) As Byte
    buffer(0) = 255
    buffer(1) = 255
    buffer(2) = 255
    buffer(3) = 255
    t1 = daveGetS8from(buffer(0))
    t2 = daveGetU8from(buffer(1))
    t3 = daveGetS16from(buffer(0))
    t4 = daveGetU16from(buffer(1))
    t5 = daveGetS32from(buffer(0))
    't6 = daveGetU32from(buffer(0))
    
    v1 = Cells(7, 2)
    a = davePut32(buffer(0), Cells(7, 2))
    a = davePut32(buffer(4), Cells(8, 2))
    a = davePut32(buffer(8), Cells(9, 2))
    a = davePutFloat(buffer(12), Cells(10, 2))
    a0 = buffer(0)
    a1 = buffer(1)
    a2 = buffer(2)
    a3 = buffer(3)
    a4 = buffer(4)
    a5 = buffer(5)
    a6 = buffer(6)
    a7 = buffer(7)
    a8 = buffer(8)
    a9 = buffer(9)
    a10 = buffer(10)
    a11 = buffer(11)
    a12 = buffer(12)
    a13 = buffer(13)
    a14 = buffer(14)
    a15 = buffer(15)
End Sub
Sub writeToPLC()
Dim buffer(1024) As Byte
Cells(1, 2) = "Testing PLC write"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
'
' Here we put thre DINTs and a REAL into the buffer. davePutXXX does the necessary conversions.
' The resulting byte pattern in the buffer is the same you would get, when you watch the PLC
' memory (FB0 .. FB15) as bytes
'
    a = davePut32(buffer(0), Cells(7, 2))
    a = davePut32(buffer(4), Cells(8, 2))
    a = davePut32(buffer(8), Cells(9, 2))
    a = davePutFloat(buffer(12), Cells(10, 2))
    res2 = daveWriteBytes(dc, daveFlags, 0, 0, 16, buffer(0))
    e$ = daveStrError(res2)
    Cells(9, 4) = "error:"
    Cells(9, 5) = e$
End If
Call cleanUp(ph, di, dc)
End Sub
'
' This is a test for passing back strings from Libnodave to VB(A):
'
Sub stringtest()
For i = 0 To 255
    a$ = daveStrError(i)
    b$ = daveAreaName(i)
    C$ = daveBlockName(i)
    Cells(6 + i, 7) = i
    Cells(6 + i, 8) = a$
    Cells(6 + i, 9) = b$
    Cells(6 + i, 10) = C$
Next i
End Sub

Sub readMultipleItemsFromPLC()
Dim resultSet As Long
Dim pdu As Long
'
' Call daveSetDebug(&HFFFF)
' You may wonder what sense it might make to set debug level, as you cannot see
' messages when you opened excel from Widows GUI.
' You can invoke Excel from the console or from a batch file with:
' <myPathToExcel>\Excel.Exe <MyPathToXLS-File>VBATest.XLS >ExcelOut
' This will start Excel with VBATest.XLS and all debug messages (and a few from Excel itself)
' go into the file ExcelOut.
'
Cells(1, 2) = "Testing multiple item PLC read"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
    pdu = daveNewPDU
    Call davePrepareReadRequest(dc, pdu)
    Call daveAddVarToReadRequest(pdu, daveFlags, 0, 0, 4)
    Call daveAddVarToReadRequest(pdu, daveFlags, 0, 8, 8)
    resultSet = daveNewResultSet
    res2 = daveExecReadRequest(dc, pdu, resultSet)
    Cells(5, 2) = res2
    If res2 = 0 Then
        res3 = daveUseResult(dc, resultSet, 0)
        v1 = daveGetS32(dc)
        Cells(7, 2) = v1
        res3 = daveUseResult(dc, resultSet, 0)
        v2 = daveGetS32(dc)
        Cells(8, 2) = v2
        v4 = daveGetFloat(dc)
        Cells(10, 2) = v4
        daveFreeResults (resultSet)
    Else
        e$ = daveStrError(res2)
        Cells(9, 4) = "error:"
        Cells(9, 5) = e$
    End If
    daveFree (resultSet)
    daveFree (pdu)
End If
Call cleanUp(ph, di, dc)
End Sub

Sub writeMultipleItemsToPLC()
Dim resultSet As Long
Dim pdu As Long
Cells(1, 2) = "Testing multiple item PLC write"
Dim ph As Long, di As Long, dc As Long
res = initialize(ph, di, dc)
If res = 0 Then
    pdu = daveNewPDU
    res = daveGetMaxPDULen(dc)
    Call davePrepareWriteRequest(dc, pdu)
    Call daveAddVarToWriteRequest(pdu, daveFlags, 0, 0, 4, buffer)
    Call daveAddVarToWriteRequest(pdu, daveDB, 6, 8, 8, buffer)
    resultSet = daveNewResultSet
    res2 = daveExecWriteRequest(dc, pdu, resultSet)
    Cells(5, 1) = "result of exec request:"
    Cells(5, 2) = res2
    If res2 = 0 Then
        res3 = daveGetErrorOfResult(resultSet, 0)
        res3 = daveGetErrorOfResult(resultSet, 1)
        daveFreeResults (resultSet)
    Else
        e$ = daveStrError(res2)
        Cells(9, 4) = "error:"
        Cells(9, 5) = e$
    End If
    daveFree (resultSet)
    daveFree (pdu)
End If
Call cleanUp(ph, di, dc)
End Sub

Sub readProgramBlock()
Cells(1, 2) = "Testing read program block OB1"
Dim ph As Long, di As Long, dc As Long, buffer(3000) As Byte, length As Long
res = initialize(ph, di, dc)
If res = 0 Then
    res = daveGetProgramBlock(dc, Asc("8"), 1, buffer(0), length)
    bpos = 0
    Cells(16, 2) = "Contents of OB1:"
    For i = 0 To 1 + Int(length / 16)
        dia$ = ""
        For j = 0 To 15
            dia$ = dia$ + Hex$(buffer(bpos)) + ","
            bpos = bpos + 1
        Next j
        Cells(i + 17, 2) = dia$
    Next i
End If
Call cleanUp(ph, di, dc)
End Sub

