Attribute VB_Name = "Version"
Option Explicit

' ***** Description:
' Lot tracking software for Siemens PLC's. Written in Visual Studio 6 service pack 6.
' MySQL version 4.1.12 and MyODBC version 3.51.11.  Running under Windows XP sp 2.

' ***** MySQL:
' Install normally.  For Server configuration:
    ' Detailed Configuration.
    ' Server Machine.
    ' Multifunctional Database.
    ' InnoDB Tablespace settings: C:\MySQL Datafiles
    ' Decision Support (DSS)/OLAP
    ' Enable TCP/IP Networking.  Port 3306.
    ' Standard character set.
    ' Install as Windows Service.  Service name: MySQL.
        'Launch the MySQL Server automatically.
        'Include Bin Directory in Windows PATH.
    ' Root password: Rube
' Install MySQL ODBC normally.
'

' ***** Function:
'The PLC has a data block set up which contains:
    'PC Count (2 bytes=1 word)
    'PLC Count (2 bytes=1 word)
    'Model (20 bytes)
    'Front lot (20 bytes)
    'Rear lot (20 bytes)
'The data block used is defined at the top of fMain.
'When the PLC has new data (model, front lot, or rear lot has changed) then
'the plc increments the short integer plc_count.
'The PC reads the entire data block defined above (64 bytes) every second.
'If PLC_Count <> PC_Count, then the PC knows there is new data present and
'records the new data.  After the new data is saved successfully, the PC writes
'back the value of PLC_Count into the PC_Count word to inform the PLC that the
'data has been saved.

'All data is stored to a MySQL database.  This program was setup and tested
'with MySQL running on the local PC.
'The user has ability to lookup data by date/time, model, lot # and
' save it to a comma delimited file which can be imported into Excel or most
' any other program which can read in a comma delimited file (.CSV)

' ***** To Do:
'1. Store PLC connection info so it is retained on next startup.
'2. Automatically re-connect after plc connection info changes.
'3. Modify fPlcEther so it will check that connection is open before it allows
    'a read/write attempt to libnodave.  libnodave will generate an access violation
    'if a read/write is attempted and no port is open!

' ***** Revision History:

' 1.0.3 11Sep06 BRR
    ' Were getting an error opening the serial port (COM2).  Problem was that the
    'string was not being passed properly to the .dll (C code).  Need to define a
    'fixed length string (actually, that's optional) but it MUST be NULL terminated.
    ' Added variable PlcConnected in fPlcSerial because libnodave will cause
    'an access violation if no port is open and a read is attempted.  So always
    'check PlcConnected before attempting to read or write to plc.  NOTE - This
    'was NOT added to fPlcEther!

' 1.0.2 30May06 BRR
    ' Modified so that if PLC is turned off or cable is disconnected, program will
    'automatically retry to connect.  Works with fPlcSerial.  Need to test yet with
    'fPlcEther.
    ' libnodave bombs if calling a read/write function and the port is not open.
    'Check first if port has been successfully opened.

' 1.0.1 05May06 BRR
    ' Found that when machine (PLC) is turned off (power disconnected), then
    'LotTrack will no longer talk to it.  Added checking so that if read fails,
    'it will close the connection and try to re-open it.
    ' Changed display on MySQL because Rear is not "only".
    
' 1.0.0 14Apr06 BRR
    ' Initial installation.  Ready for bug reports.
