VERSION 5.00
Begin VB.Form fPlcConn 
   Caption         =   "PLC Connection Configuration"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   6540
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   3195
   ScaleWidth      =   6540
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox tbSlot 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   1200
      TabIndex        =   10
      Text            =   "tbSlot"
      Top             =   1800
      Width           =   900
   End
   Begin VB.TextBox tbRack 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   1200
      TabIndex        =   9
      Text            =   "tbRack"
      Top             =   1275
      Width           =   900
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   3150
      TabIndex        =   7
      Top             =   2475
      Width           =   1065
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   675
      TabIndex        =   6
      Top             =   2475
      Width           =   1065
   End
   Begin VB.TextBox tbIPAddr 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Index           =   0
      Left            =   1200
      TabIndex        =   3
      Text            =   "192.168.250.134"
      Top             =   705
      Width           =   1575
   End
   Begin VB.TextBox tbPort 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   1200
      TabIndex        =   2
      Text            =   "102"
      Top             =   225
      Width           =   855
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Slot:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   2
      Left            =   75
      TabIndex        =   11
      Top             =   1875
      Width           =   1050
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Rack:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   1
      Left            =   75
      TabIndex        =   8
      Top             =   1320
      Width           =   1050
   End
   Begin VB.Label Label3 
      Caption         =   "IP Address is the address assigned to the PLC/CP."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Index           =   1
      Left            =   2850
      TabIndex        =   5
      Top             =   750
      Width           =   3465
   End
   Begin VB.Label Label3 
      Caption         =   "Port is the port number for the protocol, usually 102 for ISO over TCP or 1099 for the IBH/MHJ NetLink protocol."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Index           =   0
      Left            =   2175
      TabIndex        =   4
      Top             =   225
      Width           =   4140
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "IP Address:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   0
      Left            =   75
      TabIndex        =   1
      Top             =   750
      Width           =   1080
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Port:"
      Height          =   240
      Left            =   675
      TabIndex        =   0
      Top             =   300
      Width           =   405
   End
End
Attribute VB_Name = "fPlcConn"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim port%
Dim IPAddr As String * 15
Dim hPort As Long
Dim di As Long  ' Pointer to daveInterface structure.
Dim Rack&, Slot&    ' Rack # & slot # are longs.
Dim dc As Long  ' Pointer to a daveConnection structure.
'


Private Sub cmdCancel_Click()
    Hide
End Sub

Private Sub cmdOK_Click()
    port = CInt(tbPort.Text)
    IPAddr = tbIPAddr.Text
    Hide
End Sub

Public Function fPlcConnectEthernet() As Integer
Dim MpiPpi&

    hPort = openSocket(port, IPAddr)    ' for ISO over TCP

    If (hPort > 0) Then
        di = daveNewInterface(hPort, hPort, "IF1", 0, daveProtoISOTCP, daveSpeed187k)
        'You can set longer timeout here, if you have  a slow connection
        '    Call daveSetTimeout(di, 500000)
        ' 30Mar06 BRR-It appears that daveInitAdapter() is not needed for ethernet.
        'res = daveInitAdapter(di)
        'If res = 0 Then
            'MpiPpi = Cells(6, 5)
        '
        ' with ISO over TCP, set correct values for rack and slot of the CPU
        '
        Rack = CInt(tbRack.Text)
        Slot = CInt(tbSlot.Text)
        MpiPpi = 0  ' This is unused for ethernet.
        dc = daveNewConnection(di, MpiPpi, Rack, Slot)
        fPlcConnectEthernet = daveConnectPLC(dc)
    Else
        fPlcConnectEthernet = -1
    End If

End Function

'
' Disconnect from PLC, disconnect from Adapter, close the serial interface or TCP/IP socket
'
Public Function fPlcClose(ByRef ph As Long, ByRef di As Long, ByRef dc As Long) As Long
Dim res&

    fPlcClose = 0   ' Default to no error.
    If dc <> 0 Then
        res = daveDisconnectPLC(dc)
        If res Then fPlcClose = res
        Call daveFree(dc)
        dc = 0
    End If
    If di <> 0 Then
        res = daveDisconnectAdapter(di)
        If res Then fPlcClose = res
        Call daveFree(di)
        di = 0
    End If
    If hPort <> 0 Then
        res = closePort(hPort)
        If res Then fPlcClose = res
        ph = 0
    End If
    
End Function

