VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form fPlcConn 
   Caption         =   "PLC Connection Configuration"
   ClientHeight    =   5400
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   3600
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   5400
   ScaleWidth      =   3600
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdClose 
      Caption         =   "C&lose Port"
      Height          =   390
      Left            =   225
      TabIndex        =   14
      Top             =   3975
      Width           =   1140
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "O&pen Port"
      Height          =   390
      Left            =   225
      TabIndex        =   13
      Top             =   3450
      Width           =   1140
   End
   Begin VB.CommandButton cmdTestRead 
      Caption         =   "&Test Rd"
      Height          =   390
      Left            =   2250
      TabIndex        =   12
      Top             =   3450
      Width           =   1140
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   390
      Left            =   2250
      TabIndex        =   11
      Top             =   4575
      Width           =   1140
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   390
      Left            =   225
      TabIndex        =   10
      Top             =   4575
      Width           =   1140
   End
   Begin VB.Frame Frame2 
      Caption         =   "Serial Configuration"
      Height          =   3090
      Left            =   225
      TabIndex        =   1
      Top             =   150
      Width           =   3165
      Begin VB.ListBox lbParity 
         Height          =   540
         Left            =   1650
         TabIndex        =   9
         Top             =   1800
         Width           =   990
      End
      Begin VB.ListBox lbBaud 
         Height          =   540
         Left            =   1650
         TabIndex        =   8
         Top             =   1125
         Width           =   990
      End
      Begin VB.ListBox lbPort 
         Height          =   540
         ItemData        =   "fPlcSerial.frx":0000
         Left            =   1650
         List            =   "fPlcSerial.frx":0002
         TabIndex        =   7
         Top             =   450
         Width           =   990
      End
      Begin VB.TextBox tbAddr 
         Height          =   360
         Left            =   1650
         TabIndex        =   6
         Text            =   "0"
         Top             =   2475
         Width           =   840
      End
      Begin VB.Label Label1 
         Alignment       =   1  'Right Justify
         Caption         =   "Port:"
         Height          =   240
         Index           =   1
         Left            =   150
         TabIndex        =   5
         Top             =   450
         Width           =   1350
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "BAUD Rate:"
         Height          =   240
         Index           =   5
         Left            =   150
         TabIndex        =   4
         Top             =   1125
         Width           =   1350
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Parity:"
         Height          =   240
         Index           =   4
         Left            =   150
         TabIndex        =   3
         Top             =   1875
         Width           =   1350
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "MPI/PPI Addr:"
         Height          =   240
         Index           =   3
         Left            =   150
         TabIndex        =   2
         Top             =   2550
         Width           =   1350
      End
   End
   Begin MSComctlLib.StatusBar sBar 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   5085
      Width           =   3600
      _ExtentX        =   6350
      _ExtentY        =   556
      Style           =   1
      SimpleText      =   "Status Bar"
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "fPlcConn"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Uses libnodave version 0.8.2.  This module is set up to connect to an S7-200
'using an "Isolated PC/PPI Cable" configured for 9.6k baud, 11 bit, and
'DCE (switches = 01000).  The default settings of Even Parity and PLC address
'of 2 are used.  Local address is hard coded below to be 0, which is the
'default.  It defaults to COM2 because that's what I have the serial port
'in my laptop configured to.

'It connects to a S7-200 CPU 222.  Note that to read memory from the S7-200,
'this program must read DB1.

'USAGE:
    ' After loading this form, open your .ini file and either:
        'a) rc& = ReadIni(ff%) and check that return value = 0 (success) OR
        'b) Set the variables ComPort%, Baud%, Parity%, and MpiAddr% and
        'call SetUI().
            'NOTE: ComPort%, Baud%, and Parity% are 0 based indexes into
            'the list box on the form fPlcConn.  e.g. Baud%=0 -> 1200 Baud,
            'Baud%=1 -> 2400 Baud, Baud%=2 -> 9600 Baud, 3->19200, 4->38400.
'AfterThen rc& = fPlcConnect().  If rc& = 0 then connection made.  If
'connection not made successfully, check settings and cables.  This was
'tested with an S7-200.

' NOTE: This form does NOT save the port #, baud, etc.  Do
'the saving externally using functions SaveIni%(ff%) and ReadIni%(ff%).

' To read from PLC:
    ' res = fPlcRead&( Area, AreaNum, Start, numBytes, Buffer )
    
' To write to PLC:
    ' res = fPlcWrite&( Area, AreaNum, Start, NumBytes, Buffer )

' Variable for ethernet connection - needed to make all functions the same
'between fPlcSerial and fPlcEther.
Dim IPAddr As String * 15

' Variables for serial connection.
Public ComPort%, Baud%, Parity%, MpiAddr%

Private Const INI_SECTION_ID = "[fPlcConn]"

Dim hPort As Long
Dim di As Long  ' Pointer to daveInterface structure.
Public dc As Long  ' Pointer to a daveConnection structure.
Dim ErrMsg$

Dim PlcConnected As Boolean
'

'
Public Function fPlcErrMsg(ErrNum&) As String
    If ErrNum& = -1 Then
        fPlcErrMsg = ErrMsg$
    Else
        fPlcErrMsg = daveStrError(ErrNum&)
    End If
End Function

Public Function GetIP$()
    GetIP$ = IPAddr
End Function
Public Sub PutIP(NewIPAddr$)
    IPAddr$ = NewIPAddr$
End Sub

Public Function WriteIni%(FileNum%)

    Write #FileNum%, INI_SECTION_ID
    Write #FileNum%, ComPort%
    Write #FileNum%, Baud%
    Write #FileNum%, Parity%
    Write #FileNum%, MpiAddr%
    
    WriteIni% = 0
End Function

Public Function ReadIni%(FileNum%)
Dim buffer$

    While buffer$ <> INI_SECTION_ID And Not EOF(FileNum%)
        Input #FileNum%, buffer$
    Wend
    If buffer$ <> INI_SECTION_ID Then
        ReadIni% = -1
        Exit Function
    End If
    
    Input #FileNum%, ComPort%
    Input #FileNum%, Baud%
    Input #FileNum%, Parity%
    Input #FileNum%, MpiAddr%
    SetUI
    
    ReadIni% = 0
End Function

Private Sub cmdCancel_Click()
    Hide
End Sub

Private Sub cmdClose_Click()
Dim rc&

    rc& = fPlcClose&()
    If rc = 0 Then
        sBar.SimpleText = "Port closed successfully."
    Else
        sBar.SimpleText = "Port close failed: " & rc & ":" & fPlcErrMsg(rc)
    End If

End Sub

Private Sub cmdOK_Click()
Dim rc&

    GetUI
    rc = fPlcClose()
    If rc <> 0 Then
        MsgBox ("Error " & rc & " from fPlcClose().  Unable to close port, so will not attempt to re-open it.")
        Exit Sub
    End If
    rc = fPlcConnect()
    If rc = 0 Then
        Hide
    Else
        'Msgbox already displayed in fPlcConnect().
        'MsgBox ("Error " & rc & " from fPlcConnect().  Unable to connect " & _
        '    "to PLC.  Check cables and settings and try again.")
    End If

End Sub

Private Function GetUI()

    ComPort% = lbPort.ListIndex
    Baud% = lbBaud.ListIndex
    Parity% = lbParity.ListIndex
    MpiAddr% = Val(tbAddr.Text)

End Function

Private Function SetUI()
    If (ComPort% > 4) Then ComPort% = 1
    lbPort.ListIndex = ComPort%
    lbBaud.ListIndex = Baud%
    lbParity.ListIndex = Parity%
    tbAddr.Text = MpiAddr%
End Function

Public Function fPlcConnect() As Long
Dim sPort As String, sBaud As String
Dim sParity$, sParChar As Byte, rc&
Dim localMpiAddr&, PlcMpiPpiAddr&, Protocol&

    If PlcConnected Then
        rc& = fPlcClose
    End If
    
    sPort$ = lbPort.List(lbPort.ListIndex) & vbNullChar
    sBaud$ = lbBaud.List(lbBaud.ListIndex) & vbNullChar
    sParity$ = lbParity.List(lbParity.ListIndex)
    sParChar = Asc(Left$(sParity$, 1))
    hPort = setPort(sPort$, sBaud$, sParChar)
    
    If (hPort <> 0) Then
        localMpiAddr = 0
        Protocol = daveProtoPPI
        'Protocol = daveProtoMPI
        
        di = daveNewInterface(hPort, hPort, "IF1", localMpiAddr, Protocol, daveSpeed187k)
        '
        'You can set longer timeout here, if you have  a slow connection
        '    Call daveSetTimeout(di, 500000)
        PlcMpiPpiAddr = Val(tbAddr.Text)
        dc = daveNewConnection(di, PlcMpiPpiAddr, 0, 0)
        rc& = daveConnectPLC(dc)
        fPlcConnect = rc&
        If rc Then
            ErrMsg = "Error " & rc & ":" & fPlcErrMsg(rc) & " from daveConnectPLC.  " & _
                "Connection failed.  Check cables & try again."
        Else
            ErrMsg = "fPlcConnect succeeded."
            PlcConnected = True
        End If
    Else
        ErrMsg = "Unable to open " & sPort$ & " for PLC connection.  Close other programs using the port or select a different port."
        hPort = 0
        fPlcConnect = -1
    End If

End Function

'
' Disconnect from PLC, disconnect from Adapter, close the interface
'
Public Function fPlcClose() As Long
Dim res&

    fPlcClose = 0   ' Default to no error.
    If dc <> 0 Then
        res = daveDisconnectPLC(dc)
        If res Then
            fPlcClose = res
            MsgBox "Error " & res & ":" & fPlcErrMsg(res) & " from daveDisconnectPLC."
        End If
        Call daveFree(dc)
        dc = 0
    End If
    If di <> 0 Then
        res = daveDisconnectAdapter(di)
        If res Then
            fPlcClose = res
            ErrMsg = "Error " & res & ":" & fPlcErrMsg(res) & " from daveDisconnectAdapter."
        End If
        Call daveFree(di)
        di = 0
    End If
    If hPort <> 0 Then
        res = closePort(hPort)
        If res = 0 Then
            'closePort() is an oddball - it returns 0 to indicate error!
            fPlcClose = res
            ErrMsg = "Error " & res & ":" & fPlcErrMsg(res) & " from closePort."
        End If
        hPort = 0
    End If
    PlcConnected = False
    
End Function

'
'Read data from PLC.  After calling this function, call daveGet...() functions
    ' to get the data read into variables.
'Inputs: Area - Area in the plc to read.  Must be one of the constants defined
            'in libNoDave.bas.  Normally will be "daveDB" for data block.
        ' AreaNum - Data block or function block to read.
        ' Start - Starting BYTE to read.
        ' NumBytes - Number of BYTES to read.
        ' Buffer - Pointer to place to store data read.  For single thread
            'programs, this will normally be 0 (NULL).  Then the functions
            'daveGetS32(fPlcConn.dc), daveGetFloat(fPlcConn.dc)... can be
            'used to actually get the values received from the plc.
'Outputs: Result - 0 or error.
Public Function fPlcRead&(ByVal area As Long, ByVal AreaNum As Long, _
    ByVal start As Long, ByVal NumBytes As Long, ByVal buffer As Long)

    If Not PlcConnected Then
        fPlcRead = -1
        ErrMsg = "No port open."
        Exit Function
    End If
    
    fPlcRead = daveReadBytes(dc, daveDB, AreaNum, start, NumBytes, buffer)
    ' If result = 0 Then
        ' v1 = daveGetS32(dc)
        ' v2 = daveGetFloat(dc)
        ' ... Finish getting all variables read from PLC.
    ' else
        ' Error handler.
    ' endif

End Function

'
' Write data to PLC
    ' Dim buffer(1024) As Byte, a as Long, result as Long
    ' a = davePut32(buffer(0), v1)
    ' a = davePutFloat(buffer(4), v2)
    ' ... Finish putting all variables to write to plc.
    ' result = daveWriteBytes(fPlcConn.dc, daveDB, AreaNum, Start, NumBytes, buffer(0))
'Inputs:
        ' Area - Area in the plc to read.  Must be one of the constants defined
            'in libNoDave.bas.  Normally will be "daveDB" for data block.
        ' AreaNum - Data block or function block to read.
        ' Start - Starting BYTE to read.
        ' NumBytes - Number of BYTES to read.
        ' Buffer - Pointer to data to write.  Must contain at least NumBytes.
'Outputs: Result - 0 or error.
Public Function fPlcWrite&(ByVal area As Long, ByVal AreaNum As Long, _
    ByVal start As Long, ByVal NumBytes As Long, ByVal buffer As Byte)

    If Not PlcConnected Then
        fPlcWrite = -1
        ErrMsg = "No port open."
        Exit Function
    End If
    fPlcWrite = daveWriteBytes(dc, area, AreaNum, start, NumBytes, buffer)

End Function

Private Sub cmdOpen_Click()
Dim rc&

    rc = fPlcConnect&()
    If rc = 0 Then
        sBar.SimpleText = "Port opened successfully."
    ElseIf rc = -1 Then
        sBar.SimpleText = ErrMsg
    Else
        sBar.SimpleText = "Port open failed: " & rc & ":" & fPlcErrMsg(rc)
    End If
    
End Sub

Private Sub cmdTestRead_Click()
Dim rc&
Dim rBuffer(PLC_rBYTES) As Byte
Dim PlcInfo As PLC_DATA

    ' Read bytes from DB in PLC.
    sBar.SimpleText = "Reading DB" & PLC_DB & ":" & PLC_START & ". " & PLC_rBYTES & " bytes."
    rc = fPlcRead&(daveDB, PLC_DB, PLC_START, PLC_rBYTES, 0)
    If rc = 0 Then
        rc = PlcBytesToPLC_DATA(dc, PlcInfo)
        sBar.SimpleText = "Read SUCCESS. PC:" & PlcInfo.PC_Count & _
            " PLC:" & PlcInfo.PLC_Count & _
            " Mdl:" & PlcInfo.Model
    Else
        sBar.SimpleText = "Read FAILED: " & rc & ":" & fPlcErrMsg(rc)
    End If

End Sub

Private Sub Form_Load()
Dim Buff(5) As Byte

    ' Set default values.
    IPAddr = "192.168.101.1"
    
    ' Initialize serial port boxes.
    lbPort.AddItem ("COM1")
    lbPort.AddItem ("COM2")
    lbPort.AddItem ("COM3")
    lbPort.AddItem ("COM4")
    lbPort.ListIndex = 1
    lbBaud.AddItem ("1200")
    lbBaud.AddItem ("2400")
    lbBaud.AddItem ("9600")
    lbBaud.AddItem ("19200")
    lbBaud.AddItem ("38400")
    lbBaud.ListIndex = 2
    lbParity.AddItem ("Odd")
    lbParity.AddItem ("Even")
    lbParity.AddItem ("None")
    lbParity.ListIndex = 1
    tbAddr.Text = "2"

    ' Output all debug messages.
    'daveSetDebug daveDebugAll
    
End Sub

Private Sub Form_Unload(Cancel As Integer)

    fPlcClose
    
End Sub
