Attribute VB_Name = "libNoDave"
'
' Part of Libnodave, a free communication libray for Siemens S7 200/300/400 via
' the MPI adapter 6ES7 972-0CA22-0XAC
' or  MPI adapter 6ES7 972-0CA23-0XAC
' or  TS adapter 6ES7 972-0CA33-0XAC
' or  MPI adapter 6ES7 972-0CA11-0XAC,
' IBH/MHJ-NetLink or CPs 243, 343 and 443
' or VIPA Speed7 with builtin ethernet support.
'
' (C) Thomas Hergenhahn (thomas.hergenhahn@web.de) 2005
'
' Libnodave is free software; you can redistribute it and/or modify
' it under the terms of the GNU Library General Public License as published by
' the Free Software Foundation; either version 2, or (at your option)
' any later version.
'
' Libnodave is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.
'
' You should have received a copy of the GNU Library General Public License
' along with Libnodave; see the file COPYING.  If not, write to
' the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'
'
' Revisions:
' 30Mar06 Bryan Rubingh
    ' 1. Changed all Private Const to Public Const.
    ' 2. Added structure types.  These aren't needed unless debugging.
    ' 3. Changed all Private Declare to Public Declare.
    ' 4. Can't use "type" as a parameter name in internalDaveGetBlockInfo(). "type"
        ' is a reserved word.  Changed to BlkType.
    ' 5. Changed file name from modul12.bas to libNoDave.bas.
    ' 6. Removed demo functions and placed them in ExcelVBA.bas.
    ' 7. daveGetBlockInfo() function was trying to assign return value to wrong
        'variable; daveGetName = x$ instead of daveGetBlockInfo = x$

''
' Structures used in libNoDave.
'
Public Type daveInterface
    timeout As Long
End Type

Public Type daveOSserialType
    rfd As Long
    wfd As Long
End Type

Public Type daveConnection
    AnswLen As Long
    resultPointer As Long   'VB doesn't use pointers, but a pointer is a long.
    maxPDUlength As Long
End Type

''
'    Protocol types to be used with newInterface:
'
Public Const daveProtoMPI = 0      '  MPI for S7 300/400
Public Const daveProtoMPI2 = 1    '  MPI for S7 300/400, "Andrew's version"
Public Const daveProtoMPI3 = 2    '  MPI for S7 300/400, Step 7 Version, not yet implemented
Public Const daveProtoPPI = 10    '  PPI for S7 200
Public Const daveProtoAS511 = 20    '  S5 via programming interface
Public Const daveProtoS7online = 50    '  S7 using Siemens libraries & drivers for transport
Public Const daveProtoISOTCP = 122 '  ISO over TCP
Public Const daveProtoISOTCP243 = 123 '  ISO o?ver TCP with CP243
Public Const daveProtoMPI_IBH = 223   '  MPI with IBH NetLink MPI to ethernet gateway */
Public Const daveProtoPPI_IBH = 224   '  PPI with IBH NetLink PPI to ethernet gateway */
Public Const daveProtoUserTransport = 255 '  Libnodave will pass the PDUs of S7 Communication to user defined call back functions.
'
'    ProfiBus speed constants:
'
Public Const daveSpeed9k = 0
Public Const daveSpeed19k = 1
Public Const daveSpeed187k = 2
Public Const daveSpeed500k = 3
Public Const daveSpeed1500k = 4
Public Const daveSpeed45k = 5
Public Const daveSpeed93k = 6
'
'    S7 specific constants:
'
Public Const daveBlockType_OB = "8"
Public Const daveBlockType_DB = "A"
Public Const daveBlockType_SDB = "B"
Public Const daveBlockType_FC = "C"
Public Const daveBlockType_SFC = "D"
Public Const daveBlockType_FB = "E"
Public Const daveBlockType_SFB = "F"
'
' Use these constants for parameter "area" in daveReadBytes and daveWriteBytes
'
Public Const daveSysInfo = &H3      '  System info of 200 family
Public Const daveSysFlags = &H5   '  System flags of 200 family
Public Const daveAnaIn = &H6      '  analog inputs of 200 family
Public Const daveAnaOut = &H7     '  analog outputs of 200 family
Public Const daveP = &H80          ' direct access to peripheral adresses
Public Const daveInputs = &H81
Public Const daveOutputs = &H82
Public Const daveFlags = &H83
Public Const daveDB = &H84 '  data blocks
Public Const daveDI = &H85  '  instance data blocks
Public Const daveV = &H87      ' don't know what it is
Public Const daveCounter = 28  ' S7 counters
Public Const daveTimer = 29    ' S7 timers
Public Const daveCounter200 = 30       ' IEC counters (200 family)
Public Const daveTimer200 = 31         ' IEC timers (200 family)
'
Public Const daveOrderCodeSize = 21    ' Length of order code (MLFB number)
'
'    Library specific:
'
'
'    Result codes. Genarally, 0 means ok,
'    >0 are results (also errors) reported by the PLC
'    <0 means error reported by library code.
'
Public Const daveResOK = 0                        ' means all ok
Public Const daveResNoPeripheralAtAddress = 1     ' CPU tells there is no peripheral at address
Public Const daveResMultipleBitsNotSupported = 6  ' CPU tells it does not support to read a bit block with a
                                                   ' length other than 1 bit.
Public Const daveResItemNotAvailable200 = 3       ' means a a piece of data is not available in the CPU, e.g.
                                                   ' when trying to read a non existing DB or bit bloc of length<>1
                                                   ' This code seems to be specific to 200 family.
Public Const daveResItemNotAvailable = 10         ' means a a piece of data is not available in the CPU, e.g.
                                                   ' when trying to read a non existing DB
Public Const daveAddressOutOfRange = 5            ' means the data address is beyond the CPUs address range
Public Const daveWriteDataSizeMismatch = 7        ' means the write data size doesn't fit item size
Public Const daveResCannotEvaluatePDU = -123
Public Const daveResCPUNoData = -124
Public Const daveUnknownError = -125
Public Const daveEmptyResultError = -126
Public Const daveEmptyResultSetError = -127
Public Const daveResUnexpectedFunc = -128
Public Const daveResUnknownDataUnitSize = -129
Public Const daveResShortPacket = -1024
Public Const daveResTimeout = -1025
'
'    Max number of bytes in a single message.
'
Public Const daveMaxRawLen = 2048
'
'    Some definitions for debugging:
'
Public Const daveDebugRawRead = &H1            ' Show the single bytes received
Public Const daveDebugSpecialChars = &H2       ' Show when special chars are read
Public Const daveDebugRawWrite = &H4           ' Show the single bytes written
Public Const daveDebugListReachables = &H8     ' Show the steps when determine devices in MPI net
Public Const daveDebugInitAdapter = &H10       ' Show the steps when Initilizing the MPI adapter
Public Const daveDebugConnect = &H20           ' Show the steps when connecting a PLC
Public Const daveDebugPacket = &H40
Public Const daveDebugByte = &H80
Public Const daveDebugCompare = &H100
Public Const daveDebugExchange = &H200
Public Const daveDebugPDU = &H400      ' debug PDU handling
Public Const daveDebugUpload = &H800   ' debug PDU loading program blocks from PLC
Public Const daveDebugMPI = &H1000
Public Const daveDebugPrintErrors = &H2000     ' Print error messages
Public Const daveDebugPassive = &H4000
Public Const daveDebugErrorReporting = &H8000
Public Const daveDebugOpen = &H8000
Public Const daveDebugAll = &H1FFFF
'
'    Set and read debug level:
'
Public Declare Sub daveSetDebug Lib "libnodave.dll" (ByVal level As Long)
Public Declare Function daveGetDebug Lib "libnodave.dll" () As Long
'
' You may wonder what sense it might make to set debug level, as you cannot see
' messages when you opened excel or some VB application from Windows GUI.
' You can invoke Excel from the console or from a batch file with:
' <myPathToExcel>\Excel.Exe <MyPathToXLS-File>VBATest.XLS >ExcelOut
' This will start Excel with VBATest.XLS and all debug messages (and a few from Excel itself)
' go into the file ExcelOut.
'
'    Error code to message string conversion:
'    Call this function to get an explanation for error codes returned by other functions.
'
'
' The folowing doesn't work properly. A VB string is something different from a pointer to char:
'
' public declare Function daveStrerror Lib "libnodave.dll" Alias "daveStrerror" (ByVal en As Long) As String
'
Public Declare Function daveInternalStrerror Lib "libnodave.dll" Alias "daveStrerror" (ByVal en As Long) As Long
' So, I added another function to libnodave wich copies the text into a VB String.
' This function is still not useful without some code araound it, so I call it "internal"
Public Declare Sub daveStringCopy Lib "libnodave.dll" (ByVal internalPointer As Long, ByVal s As String)
'
' Setup a new interface structure using a handle to an open port or socket:
'
Public Declare Function daveNewInterface Lib "libnodave.dll" (ByVal fd1 As Long, ByVal fd2 As Long, ByVal name As String, ByVal localMPI As Long, ByVal Protocol As Long, ByVal Speed As Long) As Long
'
' Setup a new connection structure using an initialized daveInterface and PLC's MPI address.
' Note: The parameter di must have been obtained from daveNewinterface.
'
Public Declare Function daveNewConnection Lib "libnodave.dll" (ByVal di As Long, ByVal mpi As Long, ByVal Rack As Long, ByVal Slot As Long) As Long
'
'    PDU handling:
'    PDU is the central structure present in S7 communication.
'    It is composed of a 10 or 12 byte header,a parameter block and a data block.
'    When reading or writing values, the data field is itself composed of a data
'    header followed by payload data
'
'    retrieve the answer:
'    Note: The parameter dc must have been obtained from daveNewConnection.
'
Public Declare Function daveGetResponse Lib "libnodave.dll" (ByVal dc As Long) As Long
'
'    send PDU to PLC
'    Note: The parameter dc must have been obtained from daveNewConnection,
'          The parameter pdu must have been obtained from daveNewPDU.
'
Public Declare Function daveSendMessage Lib "libnodave.dll" (ByVal dc As Long, ByVal pdu As Long) As Long
'******
'
'Utilities:
'
'****
'*
'    Hex dump PDU:
'
Public Declare Sub daveDumpPDU Lib "libnodave.dll" (ByVal pdu As Long)
'
'    Hex dump. Write the name followed by len bytes written in hex and a newline:
'
Public Declare Sub daveDump Lib "libnodave.dll" (ByVal name As String, ByVal pdu As Long, ByVal length As Long)
'
'    names for PLC objects. This is again the intenal function. Use the wrapper code below.
'
Public Declare Function daveInternalAreaName Lib "libnodave.dll" Alias "daveAreaName" (ByVal en As Long) As Long
Public Declare Function daveInternalBlockName Lib "libnodave.dll" Alias "daveBlockName" (ByVal en As Long) As Long
'
'   swap functions. They change the byte order, if byte order on the computer differs from
'   PLC byte order:
'
Public Declare Function daveSwapIed_16 Lib "libnodave.dll" (ByVal x As Long) As Long
Public Declare Function daveSwapIed_32 Lib "libnodave.dll" (ByVal x As Long) As Long
'
'    Data conversion convenience functions. The older set has been removed.
'    Newer conversion routines. As the terms WORD, INT, INTEGER etc have different meanings
'    for users of different programming languages and compilers, I choose to provide a new
'    set of conversion routines named according to the bit length of the value used. The 'U'
'    or 'S' stands for unsigned or signed.
'
'
'    Get a value from the position b points to. B is typically a pointer to a buffer that has
'    been filled with daveReadBytes:
'
Public Declare Function toPLCfloat Lib "libnodave.dll" (ByVal f As Single) As Single
Public Declare Function daveToPLCfloat Lib "libnodave.dll" (ByVal f As Single) As Long
'
' Copy and convert value of 8,16,or 32 bit, signed or unsigned at position pos
' from internal buffer:
'
Public Declare Function daveGetS8from Lib "libnodave.dll" (ByRef buffer As Byte) As Long
Public Declare Function daveGetU8from Lib "libnodave.dll" (ByRef buffer As Byte) As Long
Public Declare Function daveGetS16from Lib "libnodave.dll" (ByRef buffer As Byte) As Long
Public Declare Function daveGetU16from Lib "libnodave.dll" (ByRef buffer As Byte) As Long
Public Declare Function daveGetS32from Lib "libnodave.dll" (ByRef buffer As Byte) As Long
'
' Is there an unsigned long? Or a longer integer than long? This doesn't work.
' public declare Function daveGetU32from Lib "libnodave.dll" (ByRef buffer As Byte) As Long
'
Public Declare Function daveGetFloatfrom Lib "libnodave.dll" (ByRef buffer As Byte) As Single
'
' Copy and convert a value of 8,16,or 32 bit, signed or unsigned from internal buffer. These
' functions increment an internal buffer position. This buffer position is set to zero by
' daveReadBytes, daveReadBits, daveReadSZL.
'
Public Declare Function daveGetS8 Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveGetU8 Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveGetS16 Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveGetU16 Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveGetS32 Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' Is there an unsigned long? Or a longer integer than long? This doesn't work.
'public declare Function daveGetU32 Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveGetFloat Lib "libnodave.dll" (ByVal dc As Long) As Single
'
' Read a value of 8,16,or 32 bit, signed or unsigned at position pos from internal buffer:
'
Public Declare Function daveGetS8At Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
Public Declare Function daveGetU8At Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
Public Declare Function daveGetS16At Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
Public Declare Function daveGetU16At Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
Public Declare Function daveGetS32At Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
'
' Is there an unsigned long? Or a longer integer than long? This doesn't work.
'public declare Function daveGetU32At Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
Public Declare Function daveGetFloatAt Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Single
'
' Copy and convert a value of 8,16,or 32 bit, signed or unsigned into a buffer. The buffer
' is usually used by daveWriteBytes, daveWriteBits later.
'
Public Declare Function davePut8 Lib "libnodave.dll" (ByRef buffer As Byte, ByVal value As Long) As Long
Public Declare Function davePut16 Lib "libnodave.dll" (ByRef buffer As Byte, ByVal value As Long) As Long
Public Declare Function davePut32 Lib "libnodave.dll" (ByRef buffer As Byte, ByVal value As Long) As Long
Public Declare Function davePutFloat Lib "libnodave.dll" (ByRef buffer As Byte, ByVal value As Single) As Long
'
' Copy and convert a value of 8,16,or 32 bit, signed or unsigned to position pos of a buffer.
' The buffer is usually used by daveWriteBytes, daveWriteBits later.
'
Public Declare Function davePut8At Lib "libnodave.dll" (ByRef buffer As Byte, ByVal pos As Long, ByVal value As Long) As Long
Public Declare Function davePut16At Lib "libnodave.dll" (ByRef buffer As Byte, ByVal pos As Long, ByVal value As Long) As Long
Public Declare Function davePut32At Lib "libnodave.dll" (ByRef buffer As Byte, ByVal pos As Long, ByVal value As Long) As Long
Public Declare Function davePutFloatAt Lib "libnodave.dll" (ByRef buffer As Byte, ByVal pos As Long, ByVal value As Single) As Long
'
' Takes a timer value and converts it into seconds:
'
Public Declare Function daveGetSeconds Lib "libnodave.dll" (ByVal dc As Long) As Single
Public Declare Function daveGetSecondsAt Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Single
'
' Takes a counter value and converts it to integer:
'
Public Declare Function daveGetCounterValue Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveGetCounterValueAt Lib "libnodave.dll" (ByVal dc As Long, ByVal pos As Long) As Long
'
' Get the order code (MLFB number) from a PLC. Does NOT work with 200 family.
'
Public Declare Function daveGetOrderCode Lib "libnodave.dll" (ByVal en As Long, ByRef buffer As Byte) As Long
'
' Connect to a PLC.
'
Public Declare Function daveConnectPLC Lib "libnodave.dll" (ByVal dc As Long) As Long
'
'
' Read a value or a block of values from PLC.
'
Public Declare Function daveReadBytes Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByVal buffer As Long) As Long
'
' Read a long block of values from PLC. Long means too long to transport in a single PDU.
'
Public Declare Function daveManyReadBytes Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByVal buffer As Long) As Long
'
' Write a value or a block of values to PLC.
'
Public Declare Function daveWriteBytes Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByRef buffer As Byte) As Long
'
' Write a long block of values to PLC. Long means too long to transport in a single PDU.
'
Public Declare Function daveWriteManyBytes Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByRef buffer As Byte) As Long
'
' Read a bit from PLC. numBytes must be exactly one with all PLCs tested.
' Start is calculated as 8*byte number+bit number.
'
Public Declare Function daveReadBits Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByVal buffer As Long) As Long
'
' Write a bit to PLC. numBytes must be exactly one with all PLCs tested.
'
Public Declare Function daveWriteBits Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByRef buffer As Byte) As Long
'
' Set a bit in PLC to 1.
'
Public Declare Function daveSetBit Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal byteAddress As Long, ByVal bitAddress As Long) As Long
'
' Set a bit in PLC to 0.
'
Public Declare Function daveClrBit Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal byteAddress As Long, ByVal bitAddress As Long) As Long
'
' Read a diagnostic list (SZL) from PLC. Does NOT work with 200 family.
'
Public Declare Function daveReadSZL Lib "libnodave.dll" (ByVal dc As Long, ByVal ID As Long, ByVal index As Long, ByRef buffer As Byte) As Long
'
Public Declare Function daveListBlocksOfType Lib "libnodave.dll" (ByVal dc As Long, ByVal typ As Long, ByRef buffer As Byte) As Long
Public Declare Function daveListBlocks Lib "libnodave.dll" (ByVal dc As Long, ByRef buffer As Byte) As Long
' 30Mar06 BRR - Changed variable name "type" to "BlkType" since "type" is a reserved word.
Public Declare Function internalDaveGetBlockInfo Lib "libnodave.dll" Alias "daveGetBlockInfo" (ByVal dc As Long, ByRef buffer As Byte, ByVal BlkType As Long, ByVal number As Long) As Long
'
Public Declare Function daveGetProgramBlock Lib "libnodave.dll" (ByVal dc As Long, ByVal blockType As Long, ByVal number As Long, ByRef buffer As Byte, ByRef length As Long) As Long
'
' Start or Stop a PLC:
'
Public Declare Function daveStart Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveStop Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' Set outputs (digital or analog ones) of an S7-200 that is in stop mode:
'
Public Declare Function daveForce200 Lib "libnodave.dll" (ByVal dc As Long, ByVal area As Long, ByVal start As Long, ByVal value As Long) As Long
'
' Initialize a multivariable read request.
' The parameter PDU must have been obtained from daveNew PDU:
'
Public Declare Sub davePrepareReadRequest Lib "libnodave.dll" (ByVal dc As Long, ByVal pdu As Long)
'
' Add a new variable to a prepared request:
'
Public Declare Sub daveAddVarToReadRequest Lib "libnodave.dll" (ByVal pdu As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long)
'
' Executes the entire request:
'
Public Declare Function daveExecReadRequest Lib "libnodave.dll" (ByVal dc As Long, ByVal pdu As Long, ByVal rs As Long) As Long
'
' Use the n-th result. This lets the functions daveGet<data type> work on that part of the
' internal buffer that contains the n-th result:
'
Public Declare Function daveUseResult Lib "libnodave.dll" (ByVal dc As Long, ByVal rs As Long, ByVal resultNumber As Long) As Long
'
' Frees the memory occupied by single results in the result structure. After that, you can reuse
' the resultSet in another call to daveExecReadRequest.
'
Public Declare Sub daveFreeResults Lib "libnodave.dll" (ByVal rs As Long)
'
' Adds a new bit variable to a prepared request. As with daveReadBits, numBytes must be one for
' all tested PLCs.
'
Public Declare Sub daveAddBitVarToReadRequest Lib "libnodave.dll" (ByVal pdu As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long)
'
' Initialize a multivariable write request.
' The parameter PDU must have been obtained from daveNew PDU:
'
Public Declare Sub davePrepareWriteRequest Lib "libnodave.dll" (ByVal dc As Long, ByVal pdu As Long)
'
' Add a new variable to a prepared write request:
'
Public Declare Sub daveAddVarToWriteRequest Lib "libnodave.dll" (ByVal pdu As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByRef buffer As Byte)
'
' Add a new bit variable to a prepared write request:
'
Public Declare Sub daveAddBitVarToWriteRequest Lib "libnodave.dll" (ByVal pdu As Long, ByVal area As Long, ByVal areaNumber As Long, ByVal start As Long, ByVal NumBytes As Long, ByRef buffer As Byte)
'
' Execute the entire write request:
'
Public Declare Function daveExecWriteRequest Lib "libnodave.dll" (ByVal dc As Long, ByVal pdu As Long, ByVal rs As Long) As Long
'
' Initialize an MPI Adapter or NetLink Ethernet MPI gateway.
' While some protocols do not need this, I recommend to allways use it. It will do nothing if
' the protocol doesn't need it. But you can change protocols without changing your program code.
'
Public Declare Function daveInitAdapter Lib "libnodave.dll" (ByVal di As Long) As Long
'
' Disconnect from a PLC. While some protocols do not need this, I recommend to allways use it.
' It will do nothing if the protocol doesn't need it. But you can change protocols without
' changing your program code.
'
Public Declare Function daveDisconnectPLC Lib "libnodave.dll" (ByVal dc As Long) As Long
'
'
' Disconnect from an MPI Adapter or NetLink Ethernet MPI gateway.
' While some protocols do not need this, I recommend to allways use it.
' It will do nothing if the protocol doesn't need it. But you can change protocols without
' changing your program code.
'
Public Declare Function daveDisconnectAdapter Lib "libnodave.dll" (ByVal dc As Long) As Long
'
'
' List nodes on an MPI or Profibus Network:
'
Public Declare Function daveListReachablePartners Lib "libnodave.dll" (ByVal dc As Long, ByRef buffer As Byte) As Long
'
'
' Set/change the timeout for an interface:
'
Public Declare Sub daveSetTimeout Lib "libnodave.dll" (ByVal di As Long, ByVal maxTime As Long)
'
' Read the timeout setting for an interface:
'
Public Declare Function daveGetTimeout Lib "libnodave.dll" (ByVal di As Long)
'
' Get the name of an interface. Do NOT use this, but the wrapper function defined below!
'
Public Declare Function daveInternalGetName Lib "libnodave.dll" Alias "daveGetName" (ByVal en As Long) As Long
'
' Get the MPI address of a connection.
'
Public Declare Function daveGetMPIAdr Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' Get the length (in bytes) of the last data received on a connection.
'
Public Declare Function daveGetAnswLen Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' Get the maximum length of a communication packet (PDU).
' This value depends on your CPU and connection type. It is negociated in daveConnectPLC.
' A simple read can read MaxPDULen-18 bytes.
'
Public Declare Function daveGetMaxPDULen Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' Reserve memory for a resultSet and get a handle to it:
'
Public Declare Function daveNewResultSet Lib "libnodave.dll" () As Long
'
' Destroy handles to daveInterface, daveConnections, PDUs and resultSets
' Free the memory reserved for them.
'
Public Declare Sub daveFree Lib "libnodave.dll" (ByVal item As Long)
'
' Reserve memory for a PDU and get a handle to it:
'
Public Declare Function daveNewPDU Lib "libnodave.dll" () As Long
'
' Get the error code of the n-th single result in a result set:
'
Public Declare Function daveGetErrorOfResult Lib "libnodave.dll" (ByVal resultSet As Long, ByVal resultNumber As Long) As Long
'
Public Declare Function daveForceDisconnectIBH Lib "libnodave.dll" (ByVal di As Long, ByVal src As Long, ByVal dest As Long, ByVal mpi As Long) As Long
'
' Helper functions to open serial ports and IP connections. You can use others if you want and
' pass their results to daveNewInterface.
'
' Open a serial port using name, baud rate and parity. Everything else is set automatically:
'
Public Declare Function setPort Lib "libnodave.dll" (ByVal portName As String, ByVal baudrate As String, ByVal Parity As Byte) As Long
'
' Open a TCP/IP connection using port number (1099 for NetLink, 102 for ISO over TCP) and
' IP address. You must use an IP address, NOT a hostname!
'
' 30Mar06 BRR - openSocket() is not in libnodave.dll!
Public Declare Function openSocket Lib "libnodave.dll" (ByVal port As Long, ByVal peer As String) As Long
'
' Open an access point. This is a name in you can add in the "set Programmer/PLC interface" dialog.
' To the access point, you can assign an interface like MPI adapter, CP511 etc.
'
Public Declare Function openS7online Lib "libnodave.dll" (ByVal peer As String) As Long
'
' Close connections and serial ports opened with above functions:
'
Public Declare Function closePort Lib "libnodave.dll" (ByVal fh As Long) As Long
'
' Close handle opende by opens7online:
'
Public Declare Function closeS7online Lib "libnodave.dll" (ByVal fh As Long) As Long
'
' Read Clock time from PLC:
'
Public Declare Function daveReadPLCTime Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' set clock to a value given by user
'
Public Declare Function daveSetPLCTime Lib "libnodave.dll" (ByVal dc As Long, ByRef timestamp As Byte) As Long
'
' set clock to PC system clock:
'
Public Declare Function daveSetPLCTimeToSystime Lib "libnodave.dll" (ByVal dc As Long) As Long
'
'       BCD conversions:
'
Public Declare Function daveToBCD Lib "libnodave.dll" (ByVal dc As Long) As Long
Public Declare Function daveFromBCD Lib "libnodave.dll" (ByVal dc As Long) As Long
'
' Here comes the wrapper code for functions returning strings:
'
Public Function daveStrError(ByVal code As Long) As String
    x$ = String$(256, 0)            'create a string of sufficient capacity
    ip = daveInternalStrerror(code)    ' have the text for code copied in
    Call daveStringCopy(ip, x$)    ' have the text for code copied in
    x$ = Left$(x$, InStr(x$, Chr$(0)) - 1) ' adjust the length
    daveStrError = x$                       ' and return result
End Function

Public Function daveAreaName(ByVal code As Long) As String
    x$ = String$(256, 0)            'create a string of sufficient capacity
    ip = daveInternalAreaName(code)    ' have the text for code copied in
    Call daveStringCopy(ip, x$)    ' have the text for code copied in
    x$ = Left$(x$, InStr(x$, Chr$(0)) - 1) ' adjust the length
    daveAreaName = x$                       ' and return result
End Function
Public Function daveBlockName(ByVal code As Long) As String
    x$ = String$(256, 0)            'create a string of sufficient capacity
    ip = daveInternalBlockName(code)    ' have the text for code copied in
    Call daveStringCopy(ip, x$)    ' have the text for code copied in
    x$ = Left$(x$, InStr(x$, Chr$(0)) - 1) ' adjust the length
    daveBlockName = x$                       ' and return result
End Function
Public Function daveGetName(ByVal di As Long) As String
    x$ = String$(256, 0)            'create a string of sufficient capacity
    ip = daveInternalGetName(di)    ' have the text for code copied in
    Call daveStringCopy(ip, x$)    ' have the text for code copied in
    x$ = Left$(x$, InStr(x$, Chr$(0)) - 1) ' adjust the length
    daveGetName = x$                       ' and return result
End Function
Public Function daveGetBlockInfo(ByVal di As Long) As Byte
    x$ = String$(256, 0)            'create a string of sufficient capacity
    ip = daveInternalGetName(di)    ' have the text for code copied in
    Call daveStringCopy(ip, x$)    ' have the text for code copied in
    x$ = Left$(x$, InStr(x$, Chr$(0)) - 1) ' adjust the length
    '30Mar06 BRR-Should be daveGetBlockInfo.
    'daveGetName = x$                       ' and return result
    daveGetBlockInfo = x$                       ' and return result
End Function
'
'*****************************************************
' End of interface declarations and helper functions.
'*****************************************************

