# -*- coding: utf-8 -*-
#
# cocotb documentation build configuration file
#
# This file is execfile()d with the current directory set to its containing dir.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import datetime
import os
import subprocess
import sys

# Add in-tree extensions to path
sys.path.insert(0, os.path.abspath("../sphinxext"))

import cocotb
from cocotb._vendor.distutils_version import LooseVersion

os.environ["SPHINX_BUILD"] = "1"

# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.imgmath",
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    "sphinx.ext.extlinks",
    "sphinx.ext.intersphinx",
    "sphinxcontrib.makedomain",
    "sphinx.ext.inheritance_diagram",
    "sphinxcontrib.cairosvgconverter",
    "breathe",
    "sphinx_issues",
    "sphinxarg.ext",
    "sphinxcontrib.spelling",
    "sphinx_tabs.tabs",
    "sphinxcontrib.details.directive",
]

intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "ghdl": ("https://ghdl.readthedocs.io/en/latest", None),
    "scapy": ("https://scapy.readthedocs.io/en/latest", None),
}

# Github repo
issues_github_path = "cocotb/cocotb"

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = ".rst"

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "cocotb"
copyright = "2014-{0}, cocotb contributors".format(datetime.datetime.now().year)

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The full version, including alpha/beta/rc tags.
release = cocotb.__version__
# The short X.Y version.
v_major, v_minor = LooseVersion(release).version[:2]
version = "{}.{}".format(v_major, v_minor)

autoclass_content = "both"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = [
    # these are compiled into a single file at build-time,
    # so there is no need to build them separately:
    "newsfragments/*.rst",
    # unused outputs from breathe:
    "generated/namespacelist.rst",
    "generated/namespace/*.rst",
]

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

# The Read the Docs theme is available from
# https://github.com/snide/sphinx_rtd_theme
#
# Install with
# - pip install sphinx_rtd_theme
# or
# - apt-get install python-sphinx-rtd-theme

try:
    import sphinx_rtd_theme

    html_theme = "sphinx_rtd_theme"
except ImportError:
    sys.stderr.write(
        "Warning: The Sphinx 'sphinx_rtd_theme' HTML theme was "
        + "not found. Make sure you have the theme installed to produce pretty "
        + "HTML output. Falling back to the default theme.\n"
    )

    html_theme = "default"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = dict(
    logo_only=True,
)

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = "_static/cocotb-logo-white.svg"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = "cocotbdoc"


# -- Options for LaTeX output --------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #'preamble': '',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
    ("index", "cocotb.tex", "cocotb Documentation", "cocotb contributors", "manual"),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True


# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [("index", "cocotb", "cocotb Documentation", ["cocotb contributors"], 1)]

# If true, show URL addresses after external links.
# man_show_urls = False


# -- Options for Texinfo output ------------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        "index",
        "cocotb",
        "cocotb Documentation",
        "cocotb contributors",
        "cocotb",
        "Coroutine Cosimulation TestBench \
     environment for efficient verification of RTL using Python.",
        "Miscellaneous",
    ),
]

# Documents to append as an appendix to all manuals.
# texinfo_appendices = []

# If false, no module index is generated.
# texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
# texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
# texinfo_no_detailmenu = False

todo_include_todos = False

# -- Extra setup for C documentation with Doxygen and breathe ------------------
# see also https://breathe.readthedocs.io/en/latest/readthedocs.html
subprocess.run("doxygen", cwd="..")

cpp_id_attributes = ["GPI_EXPORT"]
breathe_projects = {"cocotb": "doxygen/_xml"}
breathe_default_project = "cocotb"
breathe_domain_by_extension = {
    "h": "cpp",
}
breathe_show_define_initializer = True

# -- Extra setup for spelling check --------------------------------------------

# Spelling language.
spelling_lang = "en_US"
tokenizer_lang = spelling_lang

# Location of word list.
spelling_word_list_filename = ["spelling_wordlist.txt"]
spelling_exclude_patterns = ["generated/**", "master-notes.rst"]

spelling_ignore_pypi_package_names = False
spelling_ignore_wiki_words = False
spelling_show_suggestions = True
spelling_ignore_acronyms = True

# -- Extra setup for inheritance_diagram directive which uses graphviz ---------

graphviz_output_format = "svg"

# -- Extra setup for towncrier -------------------------------------------------
# see also https://towncrier.readthedocs.io/en/actual-freaking-docs/

# we pass the name and version directly, to avoid towncrier failing to import the non-installed version
in_progress_notes = subprocess.check_output(
    ["towncrier", "--draft", "--name", "cocotb", "--version", release],
    cwd="../..",
    universal_newlines=True,
)
with open("master-notes.rst", "w") as f:
    f.write(in_progress_notes)

# -- External link helpers -----------------------------------------------------

extlinks = {
    "wikipedia": ("https://en.wikipedia.org/wiki/%s", None),
    "reposharp": ("https://github.com/cocotb/cocotb/issues/%s", "#"),
    "reposrc": ("https://github.com/cocotb/cocotb/blob/master/%s", None),
}
