/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.TrueTypeFont;
import java.io.IOException;
import java.util.HashMap;

class EnumerateTTC
extends TrueTypeFont {
    protected String[] names;

    EnumerateTTC(String string) throws DocumentException, IOException {
        this.fileName = string;
        this.rf = new RandomAccessFileOrArray(string);
        this.findNames();
    }

    EnumerateTTC(byte[] byArray) throws DocumentException, IOException {
        this.fileName = "Byte array TTC";
        this.rf = new RandomAccessFileOrArray(byArray);
        this.findNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findNames() throws DocumentException, IOException {
        this.tables = new HashMap();
        try {
            String string = this.readStandardString(4);
            if (!string.equals("ttcf")) {
                throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.valid.ttc.file", this.fileName));
            }
            this.rf.skipBytes(4);
            int n = this.rf.readInt();
            this.names = new String[n];
            int n2 = this.rf.getFilePointer();
            for (int i = 0; i < n; ++i) {
                this.tables.clear();
                this.rf.seek(n2);
                this.rf.skipBytes(i * 4);
                this.directoryOffset = this.rf.readInt();
                this.rf.seek(this.directoryOffset);
                if (this.rf.readInt() != 65536) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.valid.ttf.file", this.fileName));
                }
                int n3 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                for (int j = 0; j < n3; ++j) {
                    String string2 = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(string2, nArray);
                }
                this.names[i] = this.getBaseFont();
            }
        }
        finally {
            if (this.rf != null) {
                this.rf.close();
            }
        }
    }

    String[] getNames() {
        return this.names;
    }
}

