/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfTemplate;

public class PdfFormXObject
extends PdfStream {
    public static final PdfNumber ZERO = new PdfNumber(0);
    public static final PdfNumber ONE = new PdfNumber(1);
    public static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate pdfTemplate, int n) {
        PdfArray pdfArray;
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.FORM);
        this.put(PdfName.RESOURCES, pdfTemplate.getResources());
        this.put(PdfName.BBOX, new PdfRectangle(pdfTemplate.getBoundingBox()));
        this.put(PdfName.FORMTYPE, ONE);
        if (pdfTemplate.getLayer() != null) {
            this.put(PdfName.OC, pdfTemplate.getLayer().getRef());
        }
        if (pdfTemplate.getGroup() != null) {
            this.put(PdfName.GROUP, pdfTemplate.getGroup());
        }
        if ((pdfArray = pdfTemplate.getMatrix()) == null) {
            this.put(PdfName.MATRIX, MATRIX);
        } else {
            this.put(PdfName.MATRIX, pdfArray);
        }
        this.bytes = pdfTemplate.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        this.flateCompress(n);
    }
}

