/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMYKColor;
import com.itextpdf.text.pdf.ColorDetails;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFunction;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.SpotColor;
import java.io.IOException;

public class PdfShading {
    protected PdfDictionary shading;
    protected PdfWriter writer;
    protected int shadingType;
    protected ColorDetails colorDetails;
    protected PdfName shadingName;
    protected PdfIndirectReference shadingReference;
    private BaseColor cspace;
    protected float[] bBox;
    protected boolean antiAlias = false;

    protected PdfShading(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    protected void setColorSpace(BaseColor baseColor) {
        this.cspace = baseColor;
        int n = ExtendedColor.getType(baseColor);
        PdfObject pdfObject = null;
        switch (n) {
            case 1: {
                pdfObject = PdfName.DEVICEGRAY;
                break;
            }
            case 2: {
                pdfObject = PdfName.DEVICECMYK;
                break;
            }
            case 3: {
                SpotColor spotColor = (SpotColor)baseColor;
                this.colorDetails = this.writer.addSimple(spotColor.getPdfSpotColor());
                pdfObject = this.colorDetails.getIndirectReference();
                break;
            }
            case 4: 
            case 5: {
                PdfShading.throwColorSpaceError();
            }
            default: {
                pdfObject = PdfName.DEVICERGB;
            }
        }
        this.shading.put(PdfName.COLORSPACE, pdfObject);
    }

    public BaseColor getColorSpace() {
        return this.cspace;
    }

    public static void throwColorSpaceError() {
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.tiling.or.shading.pattern.cannot.be.used.as.a.color.space.in.a.shading.pattern"));
    }

    public static void checkCompatibleColors(BaseColor baseColor, BaseColor baseColor2) {
        int n;
        int n2 = ExtendedColor.getType(baseColor);
        if (n2 != (n = ExtendedColor.getType(baseColor2))) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("both.colors.must.be.of.the.same.type"));
        }
        if (n2 == 3 && ((SpotColor)baseColor).getPdfSpotColor() != ((SpotColor)baseColor2).getPdfSpotColor()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.spot.color.must.be.the.same.only.the.tint.can.vary"));
        }
        if (n2 == 4 || n2 == 5) {
            PdfShading.throwColorSpaceError();
        }
    }

    public static float[] getColorArray(BaseColor baseColor) {
        int n = ExtendedColor.getType(baseColor);
        switch (n) {
            case 1: {
                return new float[]{((GrayColor)baseColor).getGray()};
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)baseColor;
                return new float[]{cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack()};
            }
            case 3: {
                return new float[]{((SpotColor)baseColor).getTint()};
            }
            case 0: {
                return new float[]{(float)baseColor.getRed() / 255.0f, (float)baseColor.getGreen() / 255.0f, (float)baseColor.getBlue() / 255.0f};
            }
        }
        PdfShading.throwColorSpaceError();
        return null;
    }

    public static PdfShading type1(PdfWriter pdfWriter, BaseColor baseColor, float[] fArray, float[] fArray2, PdfFunction pdfFunction) {
        PdfShading pdfShading = new PdfShading(pdfWriter);
        pdfShading.shading = new PdfDictionary();
        pdfShading.shadingType = 1;
        pdfShading.shading.put(PdfName.SHADINGTYPE, new PdfNumber(pdfShading.shadingType));
        pdfShading.setColorSpace(baseColor);
        if (fArray != null) {
            pdfShading.shading.put(PdfName.DOMAIN, new PdfArray(fArray));
        }
        if (fArray2 != null) {
            pdfShading.shading.put(PdfName.MATRIX, new PdfArray(fArray2));
        }
        pdfShading.shading.put(PdfName.FUNCTION, pdfFunction.getReference());
        return pdfShading;
    }

    public static PdfShading type2(PdfWriter pdfWriter, BaseColor baseColor, float[] fArray, float[] fArray2, PdfFunction pdfFunction, boolean[] blArray) {
        PdfShading pdfShading = new PdfShading(pdfWriter);
        pdfShading.shading = new PdfDictionary();
        pdfShading.shadingType = 2;
        pdfShading.shading.put(PdfName.SHADINGTYPE, new PdfNumber(pdfShading.shadingType));
        pdfShading.setColorSpace(baseColor);
        pdfShading.shading.put(PdfName.COORDS, new PdfArray(fArray));
        if (fArray2 != null) {
            pdfShading.shading.put(PdfName.DOMAIN, new PdfArray(fArray2));
        }
        pdfShading.shading.put(PdfName.FUNCTION, pdfFunction.getReference());
        if (blArray != null && (blArray[0] || blArray[1])) {
            PdfArray pdfArray = new PdfArray(blArray[0] ? PdfBoolean.PDFTRUE : PdfBoolean.PDFFALSE);
            pdfArray.add(blArray[1] ? PdfBoolean.PDFTRUE : PdfBoolean.PDFFALSE);
            pdfShading.shading.put(PdfName.EXTEND, pdfArray);
        }
        return pdfShading;
    }

    public static PdfShading type3(PdfWriter pdfWriter, BaseColor baseColor, float[] fArray, float[] fArray2, PdfFunction pdfFunction, boolean[] blArray) {
        PdfShading pdfShading = PdfShading.type2(pdfWriter, baseColor, fArray, fArray2, pdfFunction, blArray);
        pdfShading.shadingType = 3;
        pdfShading.shading.put(PdfName.SHADINGTYPE, new PdfNumber(pdfShading.shadingType));
        return pdfShading;
    }

    public static PdfShading simpleAxial(PdfWriter pdfWriter, float f, float f2, float f3, float f4, BaseColor baseColor, BaseColor baseColor2, boolean bl, boolean bl2) {
        PdfShading.checkCompatibleColors(baseColor, baseColor2);
        PdfFunction pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, PdfShading.getColorArray(baseColor), PdfShading.getColorArray(baseColor2), 1.0f);
        return PdfShading.type2(pdfWriter, baseColor, new float[]{f, f2, f3, f4}, null, pdfFunction, new boolean[]{bl, bl2});
    }

    public static PdfShading simpleAxial(PdfWriter pdfWriter, float f, float f2, float f3, float f4, BaseColor baseColor, BaseColor baseColor2) {
        return PdfShading.simpleAxial(pdfWriter, f, f2, f3, f4, baseColor, baseColor2, true, true);
    }

    public static PdfShading simpleRadial(PdfWriter pdfWriter, float f, float f2, float f3, float f4, float f5, float f6, BaseColor baseColor, BaseColor baseColor2, boolean bl, boolean bl2) {
        PdfShading.checkCompatibleColors(baseColor, baseColor2);
        PdfFunction pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, PdfShading.getColorArray(baseColor), PdfShading.getColorArray(baseColor2), 1.0f);
        return PdfShading.type3(pdfWriter, baseColor, new float[]{f, f2, f3, f4, f5, f6}, null, pdfFunction, new boolean[]{bl, bl2});
    }

    public static PdfShading simpleRadial(PdfWriter pdfWriter, float f, float f2, float f3, float f4, float f5, float f6, BaseColor baseColor, BaseColor baseColor2) {
        return PdfShading.simpleRadial(pdfWriter, f, f2, f3, f4, f5, f6, baseColor, baseColor2, true, true);
    }

    PdfName getShadingName() {
        return this.shadingName;
    }

    PdfIndirectReference getShadingReference() {
        if (this.shadingReference == null) {
            this.shadingReference = this.writer.getPdfIndirectReference();
        }
        return this.shadingReference;
    }

    void setName(int n) {
        this.shadingName = new PdfName("Sh" + n);
    }

    void addToBody() throws IOException {
        if (this.bBox != null) {
            this.shading.put(PdfName.BBOX, new PdfArray(this.bBox));
        }
        if (this.antiAlias) {
            this.shading.put(PdfName.ANTIALIAS, PdfBoolean.PDFTRUE);
        }
        this.writer.addToBody((PdfObject)this.shading, this.getShadingReference());
    }

    PdfWriter getWriter() {
        return this.writer;
    }

    ColorDetails getColorDetails() {
        return this.colorDetails;
    }

    public float[] getBBox() {
        return this.bBox;
    }

    public void setBBox(float[] fArray) {
        if (fArray.length != 4) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bbox.must.be.a.4.element.array"));
        }
        this.bBox = fArray;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }
}

