/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMYKColor;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfFunction;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfSpotColor {
    public PdfName name;
    public BaseColor altcs;

    public PdfSpotColor(String string, BaseColor baseColor) {
        this.name = new PdfName(string);
        this.altcs = baseColor;
    }

    public BaseColor getAlternativeCS() {
        return this.altcs;
    }

    protected PdfObject getSpotObject(PdfWriter pdfWriter) {
        PdfArray pdfArray = new PdfArray(PdfName.SEPARATION);
        pdfArray.add(this.name);
        PdfFunction pdfFunction = null;
        if (this.altcs instanceof ExtendedColor) {
            int n = ((ExtendedColor)this.altcs).type;
            switch (n) {
                case 1: {
                    pdfArray.add(PdfName.DEVICEGRAY);
                    pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, new float[]{0.0f}, new float[]{((GrayColor)this.altcs).getGray()}, 1.0f);
                    break;
                }
                case 2: {
                    pdfArray.add(PdfName.DEVICECMYK);
                    CMYKColor cMYKColor = (CMYKColor)this.altcs;
                    pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, new float[]{cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack()}, 1.0f);
                    break;
                }
                default: {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("only.rgb.gray.and.cmyk.are.supported.as.alternative.color.spaces"));
                }
            }
        } else {
            pdfArray.add(PdfName.DEVICERGB);
            pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, new float[]{1.0f, 1.0f, 1.0f}, new float[]{(float)this.altcs.getRed() / 255.0f, (float)this.altcs.getGreen() / 255.0f, (float)this.altcs.getBlue() / 255.0f}, 1.0f);
        }
        pdfArray.add(pdfFunction.getReference());
        return pdfArray;
    }
}

