/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.parser.ContentOperator;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class PdfContentStreamProcessor {
    private Map operators;
    private PdfDictionary resources;
    private Stack gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    private final RenderListener renderListener;

    public PdfContentStreamProcessor(RenderListener renderListener) {
        this.renderListener = renderListener;
        this.populateOperators();
        this.reset();
    }

    private void populateOperators() {
        this.operators = new HashMap();
        this.registerContentOperator("q", new PushGraphicsState());
        this.registerContentOperator("Q", new PopGraphicsState());
        this.registerContentOperator("cm", new ModifyCurrentTransformationMatrix());
        this.registerContentOperator("gs", new ProcessGraphicsStateResource());
        SetTextCharacterSpacing setTextCharacterSpacing = new SetTextCharacterSpacing();
        this.registerContentOperator("Tc", setTextCharacterSpacing);
        SetTextWordSpacing setTextWordSpacing = new SetTextWordSpacing();
        this.registerContentOperator("Tw", setTextWordSpacing);
        this.registerContentOperator("Tz", new SetTextHorizontalScaling());
        SetTextLeading setTextLeading = new SetTextLeading();
        this.registerContentOperator("TL", setTextLeading);
        this.registerContentOperator("Tf", new SetTextFont());
        this.registerContentOperator("Tr", new SetTextRenderMode());
        this.registerContentOperator("Ts", new SetTextRise());
        this.registerContentOperator("BT", new BeginText());
        this.registerContentOperator("ET", new EndText());
        TextMoveStartNextLine textMoveStartNextLine = new TextMoveStartNextLine();
        this.registerContentOperator("Td", textMoveStartNextLine);
        this.registerContentOperator("TD", new TextMoveStartNextLineWithLeading(textMoveStartNextLine, setTextLeading));
        this.registerContentOperator("Tm", new TextSetTextMatrix());
        TextMoveNextLine textMoveNextLine = new TextMoveNextLine(textMoveStartNextLine);
        this.registerContentOperator("T*", textMoveNextLine);
        ShowText showText = new ShowText();
        this.registerContentOperator("Tj", new ShowText());
        MoveNextLineAndShowText moveNextLineAndShowText = new MoveNextLineAndShowText(textMoveNextLine, showText);
        this.registerContentOperator("'", moveNextLineAndShowText);
        this.registerContentOperator("\"", new MoveNextLineAndShowTextWithSpacing(setTextWordSpacing, setTextCharacterSpacing, moveNextLineAndShowText));
        this.registerContentOperator("TJ", new ShowTextArray());
    }

    public void registerContentOperator(String string, ContentOperator contentOperator) {
        if (this.operators.containsKey(string)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("operator.1.already.registered", string));
        }
        this.operators.put(string, contentOperator);
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = null;
    }

    private GraphicsState gs() {
        return (GraphicsState)this.gsStack.peek();
    }

    private Matrix getCurrentTextMatrix() {
        return this.textMatrix;
    }

    private Matrix getCurrentTextLineMatrix() {
        return this.textLineMatrix;
    }

    private void invokeOperator(PdfLiteral pdfLiteral, ArrayList arrayList) {
        ContentOperator contentOperator = (ContentOperator)this.operators.get(pdfLiteral.toString());
        if (contentOperator == null) {
            return;
        }
        contentOperator.invoke(this, pdfLiteral, arrayList);
    }

    private String decode(PdfString pdfString) {
        byte[] byArray = pdfString.getBytes();
        return this.gs().font.decode(byArray, 0, byArray.length);
    }

    private void displayPdfString(PdfString pdfString) {
        String string = this.decode(pdfString);
        TextRenderInfo textRenderInfo = new TextRenderInfo(string, this.gs(), this.textMatrix);
        this.renderListener.renderText(textRenderInfo);
        this.textMatrix = new Matrix(textRenderInfo.getUnscaledWidth(), 0.0f).multiply(this.textMatrix);
    }

    private void applyTextAdjust(float f) {
        float f2 = -f / 1000.0f * this.gs().fontSize * this.gs().horizontalScaling;
        this.textMatrix = new Matrix(f2, 0.0f).multiply(this.textMatrix);
    }

    public void processContent(byte[] byArray, PdfDictionary pdfDictionary) {
        this.reset();
        this.resources = pdfDictionary;
        try {
            PdfContentParser pdfContentParser = new PdfContentParser(new PRTokeniser(byArray));
            ArrayList arrayList = new ArrayList();
            while (pdfContentParser.parse(arrayList).size() > 0) {
                PdfLiteral pdfLiteral = (PdfLiteral)arrayList.get(arrayList.size() - 1);
                this.invokeOperator(pdfLiteral, arrayList);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private static class EndText
    implements ContentOperator {
        private EndText() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.textMatrix = null;
            pdfContentStreamProcessor.textLineMatrix = null;
        }
    }

    private static class BeginText
    implements ContentOperator {
        private BeginText() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.textMatrix = new Matrix();
            pdfContentStreamProcessor.textLineMatrix = pdfContentStreamProcessor.textMatrix;
        }
    }

    private static class PopGraphicsState
    implements ContentOperator {
        private PopGraphicsState() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.gsStack.pop();
        }
    }

    private static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        private ModifyCurrentTransformationMatrix() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
            float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
            float f5 = ((PdfNumber)arrayList.get(4)).floatValue();
            float f6 = ((PdfNumber)arrayList.get(5)).floatValue();
            Matrix matrix = new Matrix(f, f2, f3, f4, f5, f6);
            GraphicsState graphicsState = (GraphicsState)pdfContentStreamProcessor.gsStack.peek();
            graphicsState.ctm = graphicsState.ctm.multiply(matrix);
        }
    }

    private static class PushGraphicsState
    implements ContentOperator {
        private PushGraphicsState() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            GraphicsState graphicsState = (GraphicsState)pdfContentStreamProcessor.gsStack.peek();
            GraphicsState graphicsState2 = new GraphicsState(graphicsState);
            pdfContentStreamProcessor.gsStack.push(graphicsState2);
        }
    }

    private static class ProcessGraphicsStateResource
    implements ContentOperator {
        private ProcessGraphicsStateResource() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfName pdfName = (PdfName)arrayList.get(0);
            PdfDictionary pdfDictionary = pdfContentStreamProcessor.resources.getAsDict(PdfName.EXTGSTATE);
            if (pdfDictionary == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("resources.do.not.contain.extgstate.entry.unable.to.process.operator.1", pdfLiteral));
            }
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(pdfName);
            if (pdfDictionary2 == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.is.an.unknown.graphics.state.dictionary", pdfName));
            }
            PdfArray pdfArray = pdfDictionary2.getAsArray(PdfName.FONT);
            if (pdfArray != null) {
                CMapAwareDocumentFont cMapAwareDocumentFont = new CMapAwareDocumentFont((PRIndirectReference)pdfArray.getPdfObject(0));
                float f = pdfArray.getAsNumber(1).floatValue();
                ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().font = cMapAwareDocumentFont;
                ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().fontSize = f;
            }
        }
    }

    private static class SetTextWordSpacing
    implements ContentOperator {
        private SetTextWordSpacing() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().wordSpacing = pdfNumber.floatValue();
        }
    }

    private static class SetTextCharacterSpacing
    implements ContentOperator {
        private SetTextCharacterSpacing() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().characterSpacing = pdfNumber.floatValue();
        }
    }

    private static class SetTextHorizontalScaling
    implements ContentOperator {
        private SetTextHorizontalScaling() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().horizontalScaling = pdfNumber.floatValue();
        }
    }

    private static class SetTextLeading
    implements ContentOperator {
        private SetTextLeading() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().leading = pdfNumber.floatValue();
        }
    }

    private static class SetTextRise
    implements ContentOperator {
        private SetTextRise() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().rise = pdfNumber.floatValue();
        }
    }

    private static class SetTextRenderMode
    implements ContentOperator {
        private SetTextRenderMode() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().renderMode = pdfNumber.intValue();
        }
    }

    private static class SetTextFont
    implements ContentOperator {
        private SetTextFont() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            CMapAwareDocumentFont cMapAwareDocumentFont;
            PdfName pdfName = (PdfName)arrayList.get(0);
            float f = ((PdfNumber)arrayList.get(1)).floatValue();
            PdfDictionary pdfDictionary = pdfContentStreamProcessor.resources.getAsDict(PdfName.FONT);
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().font = cMapAwareDocumentFont = new CMapAwareDocumentFont((PRIndirectReference)pdfDictionary.get(pdfName));
            ((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().fontSize = f;
        }
    }

    private static class TextMoveStartNextLine
    implements ContentOperator {
        private TextMoveStartNextLine() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            Matrix matrix = new Matrix(f, f2);
            pdfContentStreamProcessor.textMatrix = matrix.multiply(pdfContentStreamProcessor.textLineMatrix);
            pdfContentStreamProcessor.textLineMatrix = pdfContentStreamProcessor.textMatrix;
        }
    }

    private static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;
        private final SetTextLeading setTextLeading;

        public TextMoveStartNextLineWithLeading(TextMoveStartNextLine textMoveStartNextLine, SetTextLeading setTextLeading) {
            this.moveStartNextLine = textMoveStartNextLine;
            this.setTextLeading = setTextLeading;
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(1)).floatValue();
            ArrayList<PdfNumber> arrayList2 = new ArrayList<PdfNumber>(1);
            arrayList2.add(0, new PdfNumber(-f));
            this.setTextLeading.invoke(pdfContentStreamProcessor, null, arrayList2);
            this.moveStartNextLine.invoke(pdfContentStreamProcessor, null, arrayList);
        }
    }

    private static class TextSetTextMatrix
    implements ContentOperator {
        private TextSetTextMatrix() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
            float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
            float f5 = ((PdfNumber)arrayList.get(4)).floatValue();
            float f6 = ((PdfNumber)arrayList.get(5)).floatValue();
            pdfContentStreamProcessor.textLineMatrix = new Matrix(f, f2, f3, f4, f5, f6);
            pdfContentStreamProcessor.textMatrix = pdfContentStreamProcessor.textLineMatrix;
        }
    }

    private static class TextMoveNextLine
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;

        public TextMoveNextLine(TextMoveStartNextLine textMoveStartNextLine) {
            this.moveStartNextLine = textMoveStartNextLine;
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            ArrayList<PdfNumber> arrayList2 = new ArrayList<PdfNumber>(2);
            arrayList2.add(0, new PdfNumber(0));
            arrayList2.add(1, new PdfNumber(-((PdfContentStreamProcessor)pdfContentStreamProcessor).gs().leading));
            this.moveStartNextLine.invoke(pdfContentStreamProcessor, null, arrayList2);
        }
    }

    private static class ShowText
    implements ContentOperator {
        private ShowText() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfString pdfString = (PdfString)arrayList.get(0);
            pdfContentStreamProcessor.displayPdfString(pdfString);
        }
    }

    private static class MoveNextLineAndShowText
    implements ContentOperator {
        private final TextMoveNextLine textMoveNextLine;
        private final ShowText showText;

        public MoveNextLineAndShowText(TextMoveNextLine textMoveNextLine, ShowText showText) {
            this.textMoveNextLine = textMoveNextLine;
            this.showText = showText;
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            this.textMoveNextLine.invoke(pdfContentStreamProcessor, null, new ArrayList(0));
            this.showText.invoke(pdfContentStreamProcessor, null, arrayList);
        }
    }

    private static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private final SetTextWordSpacing setTextWordSpacing;
        private final SetTextCharacterSpacing setTextCharacterSpacing;
        private final MoveNextLineAndShowText moveNextLineAndShowText;

        public MoveNextLineAndShowTextWithSpacing(SetTextWordSpacing setTextWordSpacing, SetTextCharacterSpacing setTextCharacterSpacing, MoveNextLineAndShowText moveNextLineAndShowText) {
            this.setTextWordSpacing = setTextWordSpacing;
            this.setTextCharacterSpacing = setTextCharacterSpacing;
            this.moveNextLineAndShowText = moveNextLineAndShowText;
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            PdfNumber pdfNumber2 = (PdfNumber)arrayList.get(1);
            PdfString pdfString = (PdfString)arrayList.get(2);
            ArrayList<PdfNumber> arrayList2 = new ArrayList<PdfNumber>(1);
            arrayList2.add(0, pdfNumber);
            this.setTextWordSpacing.invoke(pdfContentStreamProcessor, null, arrayList2);
            ArrayList<PdfNumber> arrayList3 = new ArrayList<PdfNumber>(1);
            arrayList3.add(0, pdfNumber2);
            this.setTextCharacterSpacing.invoke(pdfContentStreamProcessor, null, arrayList3);
            ArrayList<PdfString> arrayList4 = new ArrayList<PdfString>(1);
            arrayList4.add(0, pdfString);
            this.moveNextLineAndShowText.invoke(pdfContentStreamProcessor, null, arrayList4);
        }
    }

    private static class ShowTextArray
    implements ContentOperator {
        private ShowTextArray() {
        }

        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfArray pdfArray = (PdfArray)arrayList.get(0);
            float f = 0.0f;
            ListIterator listIterator = pdfArray.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (e instanceof PdfString) {
                    pdfContentStreamProcessor.displayPdfString((PdfString)e);
                    f = 0.0f;
                    continue;
                }
                f = ((PdfNumber)e).floatValue();
                pdfContentStreamProcessor.applyTextAdjust(f);
            }
        }
    }
}

