/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.Matrix;

public class Vector {
    public static final int I1 = 0;
    public static final int I2 = 1;
    public static final int I3 = 2;
    private final float[] vals = new float[]{0.0f, 0.0f, 0.0f};

    public Vector(float f, float f2, float f3) {
        this.vals[0] = f;
        this.vals[1] = f2;
        this.vals[2] = f3;
    }

    public float get(int n) {
        return this.vals[n];
    }

    public Vector cross(Matrix matrix) {
        float f = this.vals[0] * matrix.get(0) + this.vals[1] * matrix.get(3) + this.vals[2] * matrix.get(6);
        float f2 = this.vals[0] * matrix.get(1) + this.vals[1] * matrix.get(4) + this.vals[2] * matrix.get(7);
        float f3 = this.vals[0] * matrix.get(2) + this.vals[1] * matrix.get(5) + this.vals[2] * matrix.get(8);
        return new Vector(f, f2, f3);
    }

    public Vector subtract(Vector vector) {
        float f = this.vals[0] - vector.vals[0];
        float f2 = this.vals[1] - vector.vals[1];
        float f3 = this.vals[2] - vector.vals[2];
        return new Vector(f, f2, f3);
    }

    public Vector cross(Vector vector) {
        float f = this.vals[1] * vector.vals[2] - this.vals[2] * vector.vals[1];
        float f2 = this.vals[2] * vector.vals[0] - this.vals[0] * vector.vals[2];
        float f3 = this.vals[0] * vector.vals[1] - this.vals[1] * vector.vals[0];
        return new Vector(f, f2, f3);
    }

    public float dot(Vector vector) {
        return this.vals[0] * vector.vals[0] + this.vals[1] * vector.vals[1] + this.vals[2] * vector.vals[2];
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.vals[0] * this.vals[0] + this.vals[1] * this.vals[1] + this.vals[2] * this.vals[2];
    }

    public String toString() {
        return this.vals[0] + "," + this.vals[1] + "," + this.vals[2];
    }
}

