/*
 * Decompiled with CFR 0.152.
 */
package figtree.applet;

import figtree.application.FigTreeNexusImporter;
import figtree.panel.FigTreePanel;
import figtree.panel.SimpleControlPalette;
import figtree.panel.SimpleTreeViewer;
import figtree.treeviewer.TreeViewer;
import jam.controlpalettes.ControlPalette;
import jam.panels.SearchPanel;
import jam.panels.SearchPanelListener;
import jam.panels.StatusBar;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NewickImporter;
import jebl.evolution.trees.Tree;

public class FigTreeApplet
extends JApplet {
    private SimpleTreeViewer treeViewer;
    private ControlPalette controlPalette1;
    private ControlPalette controlPalette2;
    private FigTreePanel figTreePanel;
    private StatusBar statusBar;
    private SearchPanel filterPanel;
    private JPopupMenu filterPopup;

    @Override
    public void init() {
        FigTreePanel.Style style = FigTreePanel.Style.DEFAULT;
        String string = this.getParameter("style");
        if (string != null) {
            style = FigTreePanel.Style.valueOf(string.trim().toUpperCase());
        }
        this.treeViewer = new SimpleTreeViewer();
        this.controlPalette1 = new SimpleControlPalette();
        this.controlPalette2 = new SimpleControlPalette();
        this.figTreePanel = new FigTreePanel(this.treeViewer, this.controlPalette1, this.controlPalette2, style);
        this.filterPopup = new JPopupMenu();
        for (TreeViewer.TextSearchType textSearchType : TreeViewer.TextSearchType.values()) {
            this.filterPopup.add(textSearchType.toString());
        }
        this.filterPanel = new SearchPanel("Filter", this.filterPopup, true);
        this.filterPanel.setOpaque(false);
        this.filterPanel.addSearchPanelListener(new SearchPanelListener(){

            @Override
            public void searchStarted(String string) {
                int n = FigTreeApplet.this.filterPopup.getSelectionModel().getSelectedIndex();
                if (n == -1) {
                    n = 0;
                }
                TreeViewer.TextSearchType textSearchType = TreeViewer.TextSearchType.values()[n];
                FigTreeApplet.this.treeViewer.selectTaxa("!name", textSearchType, string, false);
            }

            @Override
            public void searchStopped() {
                FigTreeApplet.this.treeViewer.clearSelectedTaxa();
            }
        });
        this.statusBar = new StatusBar("");
        this.statusBar.setStatusProvider(this.treeViewer);
        this.statusBar.add((Component)this.filterPanel, "East");
        if (style != FigTreePanel.Style.ICARUS_SMALL) {
            this.getContentPane().add((Component)this.statusBar, "North");
        }
        this.getContentPane().add((Component)this.figTreePanel, "Center");
    }

    @Override
    public void start() {
        String string = this.getParameter("tree");
        String string2 = this.getParameter("treefile");
        if (string != null && string.length() > 0) {
            URL uRL = null;
            try {
                uRL = new URL(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                this.readData(bufferedReader, true);
            }
            catch (MalformedURLException malformedURLException) {
                this.treeViewer.setStatusText(malformedURLException.getMessage());
            }
            catch (IOException iOException) {
                this.treeViewer.setStatusText(iOException.getMessage());
            }
        } else if (string2 != null && string2.length() > 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                this.readData(bufferedReader, true);
            }
            catch (IOException iOException) {
                this.treeViewer.setStatusText(iOException.getMessage());
            }
        } else {
            this.treeViewer.setStatusText("Tree not specified");
        }
    }

    @Override
    public void stop() {
    }

    protected boolean readData(Reader reader, boolean bl) throws IOException {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.controlPalette1.getSettings(hashMap);
            this.controlPalette2.getSettings(hashMap);
            if (bl) {
                FigTreeNexusImporter figTreeNexusImporter = new FigTreeNexusImporter(reader);
                while (figTreeNexusImporter.hasTree()) {
                    Tree tree = figTreeNexusImporter.importNextTree();
                    arrayList.add(tree);
                }
                try {
                    while (true) {
                        figTreeNexusImporter.findNextBlock();
                        if (!figTreeNexusImporter.getNextBlockName().equalsIgnoreCase("FIGTREE")) continue;
                        figTreeNexusImporter.parseFigTreeBlock(hashMap);
                    }
                }
                catch (EOFException eOFException) {}
            } else {
                NewickImporter newickImporter = new NewickImporter(reader, true);
                while (newickImporter.hasTree()) {
                    Tree tree = newickImporter.importNextTree();
                    arrayList.add(tree);
                }
            }
            if (arrayList.size() == 0) {
                throw new ImportException("This file contained no trees.");
            }
            this.treeViewer.setTrees(arrayList);
            this.controlPalette1.setSettings(hashMap);
            this.controlPalette2.setSettings(hashMap);
        }
        catch (ImportException importException) {
            JOptionPane.showMessageDialog(this, "Error reading tree file: " + importException, "Import Error", 0);
            return false;
        }
        return true;
    }
}

