/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import jam.panels.OptionsPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;

public class ExportTreeDialog {
    private final JDialog dialog;
    private final JOptionPane optionPane;
    private JComboBox formatCombo = null;
    private JCheckBox asDisplayedCheck = new JCheckBox("Save as currently displayed");
    private JCheckBox allTreesCheck = new JCheckBox("Save all trees");
    private JCheckBox includeFigTreeCheck = new JCheckBox("Include FigTree block (NEXUS only)");
    private JCheckBox includeAnnotationsCheck = new JCheckBox("Include Annotations (NEXUS & JSON only)");

    public ExportTreeDialog(JFrame jFrame) {
        OptionsPanel optionsPanel = new OptionsPanel(12, 12);
        this.formatCombo = new JComboBox<Format>(Format.values());
        optionsPanel.addComponentWithLabel("Tree file format: ", this.formatCombo);
        optionsPanel.addComponent(this.asDisplayedCheck);
        optionsPanel.addComponent(this.allTreesCheck);
        optionsPanel.addComponent(this.includeFigTreeCheck);
        optionsPanel.addComponent(this.includeAnnotationsCheck);
        this.optionPane = new JOptionPane(optionsPanel, 3, 2, null, null, null);
        this.optionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialog = this.optionPane.createDialog(jFrame, "Export Trees");
        this.dialog.pack();
        this.formatCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = ExportTreeDialog.this.formatCombo.getSelectedItem();
                ExportTreeDialog.this.includeFigTreeCheck.setEnabled(object.equals((Object)Format.NEXUS));
                ExportTreeDialog.this.includeAnnotationsCheck.setEnabled(object.equals((Object)Format.NEXUS) || object.equals((Object)Format.JSON));
            }
        });
    }

    public int showDialog() {
        this.dialog.setVisible(true);
        int n = 2;
        Integer n2 = (Integer)this.optionPane.getValue();
        if (n2 != null && n2 != -1) {
            n = n2;
        }
        if (n == 0) {
            // empty if block
        }
        return n;
    }

    public Format getFormat() {
        return (Format)((Object)this.formatCombo.getSelectedItem());
    }

    public boolean asDisplayed() {
        return this.asDisplayedCheck.isSelected();
    }

    public boolean allTrees() {
        return this.allTreesCheck.isSelected();
    }

    public boolean includeFigTreeBlock() {
        return this.includeFigTreeCheck.isSelected();
    }

    public boolean includeAnnotations() {
        return this.includeAnnotationsCheck.isSelected();
    }

    public static enum Format {
        NEXUS("NEXUS"),
        NEWICK("Newick"),
        JSON("JSON");

        private String name;

        private Format(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

